/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.transport.TransportRequest;

public class QuerySearchRequest
extends TransportRequest {
    private long id;
    private AggregatedDfs dfs;

    public QuerySearchRequest() {
    }

    public QuerySearchRequest(SearchRequest request, long id2, AggregatedDfs dfs) {
        super(request);
        this.id = id2;
        this.dfs = dfs;
    }

    public long id() {
        return this.id;
    }

    public AggregatedDfs dfs() {
        return this.dfs;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readLong();
        this.dfs = AggregatedDfs.readAggregatedDfs(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.id);
        this.dfs.writeTo(out);
    }
}

