/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.internal.SourceFieldSelector;

public class SourceLookup
implements Map {
    private IndexReader reader;
    private int docId = -1;
    private BytesReference sourceAsBytes;
    private Map<String, Object> source;

    public Map<String, Object> source() {
        return this.source;
    }

    private Map<String, Object> loadSourceIfNeeded() {
        if (this.source != null) {
            return this.source;
        }
        if (this.sourceAsBytes != null) {
            this.source = SourceLookup.sourceAsMap(this.sourceAsBytes);
            return this.source;
        }
        try {
            Document doc = this.reader.document(this.docId, SourceFieldSelector.INSTANCE);
            Fieldable sourceField = doc.getFieldable("_source");
            this.source = sourceField == null ? ImmutableMap.of() : SourceLookup.sourceAsMap(sourceField.getBinaryValue(), sourceField.getBinaryOffset(), sourceField.getBinaryLength());
        }
        catch (Exception e) {
            throw new ElasticSearchParseException("failed to parse / load source", e);
        }
        return this.source;
    }

    public static Map<String, Object> sourceAsMap(BytesReference source2) throws ElasticSearchParseException {
        return XContentHelper.convertToMap(source2, false).v2();
    }

    public static Map<String, Object> sourceAsMap(byte[] bytes2, int offset2, int length2) throws ElasticSearchParseException {
        return XContentHelper.convertToMap(bytes2, offset2, length2, false).v2();
    }

    public void setNextReader(IndexReader reader) {
        if (this.reader == reader) {
            return;
        }
        this.reader = reader;
        this.source = null;
        this.sourceAsBytes = null;
        this.docId = -1;
    }

    public void setNextDocId(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.sourceAsBytes = null;
        this.source = null;
    }

    public void setNextSource(BytesReference source2) {
        this.sourceAsBytes = source2;
    }

    public void setNextSource(Map<String, Object> source2) {
        this.source = source2;
    }

    public List<Object> extractRawValues(String path2) {
        return XContentMapValues.extractRawValues(path2, this.loadSourceIfNeeded());
    }

    public Object filter(String[] includes, String[] excludes) {
        return XContentMapValues.filter(this.loadSourceIfNeeded(), includes, excludes);
    }

    public Object extractValue(String path2) {
        return XContentMapValues.extractValue(path2, this.loadSourceIfNeeded());
    }

    public Object get(Object key2) {
        return this.loadSourceIfNeeded().get(key2);
    }

    @Override
    public int size() {
        return this.loadSourceIfNeeded().size();
    }

    @Override
    public boolean isEmpty() {
        return this.loadSourceIfNeeded().isEmpty();
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.loadSourceIfNeeded().containsKey(key2);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.loadSourceIfNeeded().containsValue(value2);
    }

    public Set keySet() {
        return this.loadSourceIfNeeded().keySet();
    }

    public Collection values() {
        return this.loadSourceIfNeeded().values();
    }

    public Set entrySet() {
        return this.loadSourceIfNeeded().entrySet();
    }

    public Object put(Object key2, Object value2) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key2) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

