/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.lookup.DocLookup;
import org.elasticsearch.search.lookup.FieldsLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class SearchLookup {
    final DocLookup docMap;
    final SourceLookup sourceLookup;
    final FieldsLookup fieldsLookup;
    final ImmutableMap<String, Object> asMap;

    public SearchLookup(MapperService mapperService, FieldDataCache fieldDataCache, @Nullable String[] types) {
        this.docMap = new DocLookup(mapperService, fieldDataCache, types);
        this.sourceLookup = new SourceLookup();
        this.fieldsLookup = new FieldsLookup(mapperService, types);
        this.asMap = ImmutableMap.of("doc", this.docMap, "_doc", this.docMap, "_source", this.sourceLookup, "_fields", this.fieldsLookup);
    }

    public ImmutableMap<String, Object> asMap() {
        return this.asMap;
    }

    public SourceLookup source() {
        return this.sourceLookup;
    }

    public FieldsLookup fields() {
        return this.fieldsLookup;
    }

    public DocLookup doc() {
        return this.docMap;
    }

    public void setScorer(Scorer scorer) {
        this.docMap.setScorer(scorer);
    }

    public void setNextReader(IndexReader reader) {
        this.docMap.setNextReader(reader);
        this.sourceLookup.setNextReader(reader);
        this.fieldsLookup.setNextReader(reader);
    }

    public void setNextDocId(int docId) {
        this.docMap.setNextDocId(docId);
        this.sourceLookup.setNextDocId(docId);
        this.fieldsLookup.setNextDocId(docId);
    }
}

