/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHitField;

public class InternalSearchHitField
implements SearchHitField {
    private String name;
    private List<Object> values;

    private InternalSearchHitField() {
    }

    public InternalSearchHitField(String name2, List<Object> values2) {
        this.name = name2;
        this.values = values2;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    public Object value() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        return this.values.get(0);
    }

    public Object getValue() {
        return this.value();
    }

    @Override
    public List<Object> values() {
        return this.values;
    }

    @Override
    public List<Object> getValues() {
        return this.values();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public static InternalSearchHitField readSearchHitField(StreamInput in) throws IOException {
        InternalSearchHitField result2 = new InternalSearchHitField();
        result2.readFrom(in);
        return result2;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        int size2 = in.readVInt();
        this.values = new ArrayList<Object>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.values.add(in.readGenericValue());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeVInt(this.values.size());
        for (Object value2 : this.values) {
            out.writeGenericValue(value2);
        }
    }
}

