/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight.vectorhighlight;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.XSimpleFragmentsBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;

public class SourceSimpleFragmentsBuilder
extends XSimpleFragmentsBuilder {
    private final FieldMapper mapper;
    private final SearchContext searchContext;
    public static final Field[] EMPTY_FIELDS = new Field[0];

    public SourceSimpleFragmentsBuilder(FieldMapper mapper, SearchContext searchContext, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(preTags, postTags, boundaryScanner);
        this.mapper = mapper;
        this.searchContext = searchContext;
    }

    @Override
    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        SearchLookup lookup = this.searchContext.lookup();
        lookup.setNextReader(reader);
        lookup.setNextDocId(docId);
        List<Object> values2 = lookup.source().extractRawValues(this.mapper.names().sourcePath());
        if (values2.isEmpty()) {
            return EMPTY_FIELDS;
        }
        Field[] fields2 = new Field[values2.size()];
        for (int i2 = 0; i2 < values2.size(); ++i2) {
            fields2[i2] = new Field(this.mapper.names().indexName(), values2.get(i2).toString(), Field.Store.NO, Field.Index.ANALYZED);
        }
        return fields2;
    }
}

