/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.search.highlight.WeightedSpanTermExtractor;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.lucene.search.function.FiltersFunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;

public final class CustomQueryScorer
extends QueryScorer {
    public CustomQueryScorer(Query query, IndexReader reader, String field2, String defaultField) {
        super(query, reader, field2, defaultField);
    }

    public CustomQueryScorer(Query query, IndexReader reader, String field2) {
        super(query, reader, field2);
    }

    public CustomQueryScorer(Query query, String field2, String defaultField) {
        super(query, field2, defaultField);
    }

    public CustomQueryScorer(Query query, String field2) {
        super(query, field2);
    }

    public CustomQueryScorer(Query query) {
        super(query);
    }

    public CustomQueryScorer(WeightedSpanTerm[] weightedTerms) {
        super(weightedTerms);
    }

    @Override
    protected WeightedSpanTermExtractor newTermExtractor(String defaultField) {
        return defaultField == null ? new CustomWeightedSpanTermExtractor() : new CustomWeightedSpanTermExtractor(defaultField);
    }

    private static class CustomWeightedSpanTermExtractor
    extends WeightedSpanTermExtractor {
        public CustomWeightedSpanTermExtractor() {
        }

        public CustomWeightedSpanTermExtractor(String defaultField) {
            super(defaultField);
        }

        @Override
        protected void extractUnknownQuery(Query query, Map<String, WeightedSpanTerm> terms) throws IOException {
            if (query instanceof FunctionScoreQuery) {
                query = ((FunctionScoreQuery)query).getSubQuery();
                this.extract(query, terms);
            } else if (query instanceof FiltersFunctionScoreQuery) {
                query = ((FiltersFunctionScoreQuery)query).getSubQuery();
                this.extract(query, terms);
            } else if (query instanceof ConstantScoreQuery) {
                ConstantScoreQuery q = (ConstantScoreQuery)query;
                if (q.getQuery() != null) {
                    query = q.getQuery();
                    this.extract(query, terms);
                }
            } else if (query instanceof FilteredQuery) {
                query = ((FilteredQuery)query).getQuery();
                this.extract(query, terms);
            } else if (query instanceof MultiPhrasePrefixQuery) {
                MultiPhrasePrefixQuery q = (MultiPhrasePrefixQuery)query;
                IndexReader reader = this.getReaderForField(q.getField());
                this.extract(q.rewrite(reader), terms);
            }
        }
    }
}

