/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.matchedfilters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public class MatchedFiltersFetchSubPhase
implements FetchSubPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticSearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return !context.parsedQuery().namedFilters().isEmpty();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticSearchException {
        ArrayList<String> matchedFilters = Lists.newArrayListWithCapacity(2);
        for (Map.Entry entry : context.parsedQuery().namedFilters().entrySet()) {
            String name2 = (String)entry.getKey();
            Filter filter = (Filter)entry.getValue();
            try {
                DocSet docSet;
                DocIdSet docIdSet = filter.getDocIdSet(hitContext.reader());
                if (docIdSet == null || !(docSet = DocSets.convert(hitContext.reader(), docIdSet)).get(hitContext.docId())) continue;
                matchedFilters.add(name2);
            }
            catch (IOException e) {}
        }
        hitContext.hit().matchedFilters(matchedFilters.toArray(new String[matchedFilters.size()]));
    }
}

