/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.termsstats.doubles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.trove.ExtTDoubleObjectHashMap;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.termsstats.TermsStatsFacet;
import org.elasticsearch.search.facet.termsstats.doubles.InternalTermsStatsDoubleFacet;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStatsDoubleFacetCollector
extends AbstractFacetCollector {
    private final TermsStatsFacet.ComparatorType comparatorType;
    private final FieldDataCache fieldDataCache;
    private final String keyFieldName;
    private final String valueFieldName;
    private final int size;
    private final int numberOfShards;
    private final FieldDataType keyFieldDataType;
    private NumericFieldData keyFieldData;
    private final FieldDataType valueFieldDataType;
    private final SearchScript script;
    private final Aggregator aggregator;

    public TermsStatsDoubleFacetCollector(String facetName, String keyFieldName, String valueFieldName, int size2, TermsStatsFacet.ComparatorType comparatorType, SearchContext context, String scriptLang, String script, Map<String, Object> params2) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.size = size2;
        this.comparatorType = comparatorType;
        this.numberOfShards = context.numberOfShards();
        MapperService.SmartNameFieldMappers smartMappers = context.smartFieldMappers(keyFieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            this.keyFieldName = keyFieldName;
            this.keyFieldDataType = FieldDataType.DefaultTypes.STRING;
        } else {
            if (smartMappers.explicitTypeInNameWithDocMapper()) {
                this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
            }
            this.keyFieldName = smartMappers.mapper().names().indexName();
            this.keyFieldDataType = smartMappers.mapper().fieldDataType();
        }
        if (script == null) {
            smartMappers = context.smartFieldMappers(valueFieldName);
            if (smartMappers == null || !smartMappers.hasMapper()) {
                throw new ElasticSearchIllegalArgumentException("failed to find mappings for [" + valueFieldName + "]");
            }
            this.valueFieldName = smartMappers.mapper().names().indexName();
            this.valueFieldDataType = smartMappers.mapper().fieldDataType();
            this.script = null;
            this.aggregator = new Aggregator();
        } else {
            this.valueFieldName = null;
            this.valueFieldDataType = null;
            this.script = context.scriptService().search(context.lookup(), scriptLang, script, params2);
            this.aggregator = new ScriptAggregator(this.script);
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        if (this.script != null) {
            this.script.setScorer(scorer);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyFieldData = (NumericFieldData)this.fieldDataCache.cache(this.keyFieldDataType, reader, this.keyFieldName);
        if (this.script != null) {
            this.script.setNextReader(reader);
        } else {
            this.aggregator.valueFieldData = (NumericFieldData)this.fieldDataCache.cache(this.valueFieldDataType, reader, this.valueFieldName);
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.keyFieldData.forEachValueInDoc(doc, this.aggregator);
    }

    @Override
    public Facet facet() {
        InternalTermsStatsDoubleFacet.DoubleEntry value2;
        if (this.aggregator.entries.isEmpty()) {
            return new InternalTermsStatsDoubleFacet(this.facetName, this.comparatorType, this.size, ImmutableList.<InternalTermsStatsDoubleFacet.DoubleEntry>of(), this.aggregator.missing);
        }
        if (this.size == 0) {
            return new InternalTermsStatsDoubleFacet(this.facetName, this.comparatorType, 0, this.aggregator.entries.valueCollection(), this.aggregator.missing);
        }
        Object[] values2 = this.aggregator.entries.internalValues();
        Arrays.sort(values2, this.comparatorType.comparator());
        int limit2 = this.size;
        ArrayList<InternalTermsStatsDoubleFacet.DoubleEntry> ordered = Lists.newArrayList();
        for (int i2 = 0; i2 < limit2 && (value2 = (InternalTermsStatsDoubleFacet.DoubleEntry)values2[i2]) != null; ++i2) {
            ordered.add(value2);
        }
        CacheRecycler.pushDoubleObjectMap(this.aggregator.entries);
        return new InternalTermsStatsDoubleFacet(this.facetName, this.comparatorType, this.size, ordered, this.aggregator.missing);
    }

    public static class ScriptAggregator
    extends Aggregator {
        private final SearchScript script;

        public ScriptAggregator(SearchScript script) {
            this.script = script;
        }

        @Override
        public void onValue(int docId, double value2) {
            InternalTermsStatsDoubleFacet.DoubleEntry doubleEntry = (InternalTermsStatsDoubleFacet.DoubleEntry)this.entries.get(value2);
            if (doubleEntry == null) {
                doubleEntry = new InternalTermsStatsDoubleFacet.DoubleEntry(value2, 1L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value2, doubleEntry);
            } else {
                ++doubleEntry.count;
            }
            this.script.setNextDocId(docId);
            double valueValue = this.script.runAsDouble();
            if (valueValue < doubleEntry.min) {
                doubleEntry.min = valueValue;
            }
            if (valueValue > doubleEntry.max) {
                doubleEntry.max = valueValue;
            }
            ++doubleEntry.totalCount;
            doubleEntry.total += valueValue;
        }
    }

    public static class Aggregator
    implements NumericFieldData.MissingDoubleValueInDocProc {
        final ExtTDoubleObjectHashMap<InternalTermsStatsDoubleFacet.DoubleEntry> entries = CacheRecycler.popDoubleObjectMap();
        int missing;
        NumericFieldData valueFieldData;
        final ValueAggregator valueAggregator = new ValueAggregator();

        @Override
        public void onValue(int docId, double value2) {
            InternalTermsStatsDoubleFacet.DoubleEntry doubleEntry = (InternalTermsStatsDoubleFacet.DoubleEntry)this.entries.get(value2);
            if (doubleEntry == null) {
                doubleEntry = new InternalTermsStatsDoubleFacet.DoubleEntry(value2, 0L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
                this.entries.put(value2, doubleEntry);
            }
            ++doubleEntry.count;
            this.valueAggregator.doubleEntry = doubleEntry;
            this.valueFieldData.forEachValueInDoc(docId, this.valueAggregator);
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public static class ValueAggregator
        implements NumericFieldData.DoubleValueInDocProc {
            InternalTermsStatsDoubleFacet.DoubleEntry doubleEntry;

            @Override
            public void onValue(int docId, double value2) {
                if (value2 < this.doubleEntry.min) {
                    this.doubleEntry.min = value2;
                }
                if (value2 > this.doubleEntry.max) {
                    this.doubleEntry.max = value2;
                }
                this.doubleEntry.total += value2;
                ++this.doubleEntry.totalCount;
            }
        }
    }
}

