/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;

public class StatisticalScriptFacetBuilder
extends AbstractFacetBuilder {
    private String lang;
    private String script;
    private Map<String, Object> params;

    public StatisticalScriptFacetBuilder(String name2) {
        super(name2);
    }

    @Override
    public StatisticalScriptFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public AbstractFacetBuilder scope(String scope) {
        super.scope(scope);
        return this;
    }

    @Override
    public StatisticalScriptFacetBuilder facetFilter(FilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    @Override
    public StatisticalScriptFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    public StatisticalScriptFacetBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public StatisticalScriptFacetBuilder script(String script) {
        this.script = script;
        return this;
    }

    public StatisticalScriptFacetBuilder param(String name2, Object value2) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(name2, value2);
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (this.script == null) {
            throw new SearchSourceBuilderException("script must be set on statistical script facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("statistical");
        builder.field("script", this.script);
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.params != null) {
            builder.field("params", this.params);
        }
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params2);
        builder.endObject();
        return builder;
    }
}

