/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptStatisticalFacetCollector
extends AbstractFacetCollector {
    private final SearchScript script;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double total = 0.0;
    private double sumOfSquares = 0.0;
    private long count;

    public ScriptStatisticalFacetCollector(String facetName, String scriptLang, String script, Map<String, Object> params2, SearchContext context) {
        super(facetName);
        this.script = context.scriptService().search(context.lookup(), scriptLang, script, params2);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.script.setNextDocId(doc);
        double value2 = this.script.runAsDouble();
        if (value2 < this.min) {
            this.min = value2;
        }
        if (value2 > this.max) {
            this.max = value2;
        }
        this.sumOfSquares += value2 * value2;
        this.total += value2;
        ++this.count;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.script.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.script.setNextReader(reader);
    }

    @Override
    public Facet facet() {
        return new InternalStatisticalFacet(this.facetName, this.min, this.max, this.total, this.sumOfSquares, this.count);
    }
}

