/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;
import org.elasticsearch.search.facet.AbstractFacetBuilder;

public class RangeFacetBuilder
extends AbstractFacetBuilder {
    private String keyFieldName;
    private String valueFieldName;
    private List<Entry> entries = Lists.newArrayList();

    public RangeFacetBuilder(String name2) {
        super(name2);
    }

    public RangeFacetBuilder field(String field2) {
        this.keyFieldName = field2;
        this.valueFieldName = field2;
        return this;
    }

    public RangeFacetBuilder keyField(String keyField) {
        this.keyFieldName = keyField;
        return this;
    }

    public RangeFacetBuilder valueField(String valueField) {
        this.valueFieldName = valueField;
        return this;
    }

    public RangeFacetBuilder addRange(double from, double to) {
        this.entries.add(new Entry(from, to));
        return this;
    }

    public RangeFacetBuilder addRange(String from, String to) {
        this.entries.add(new Entry(from, to));
        return this;
    }

    public RangeFacetBuilder addUnboundedTo(double from) {
        this.entries.add(new Entry(from, Double.POSITIVE_INFINITY));
        return this;
    }

    public RangeFacetBuilder addUnboundedTo(String from) {
        this.entries.add(new Entry(from, null));
        return this;
    }

    public RangeFacetBuilder addUnboundedFrom(double to) {
        this.entries.add(new Entry(Double.NEGATIVE_INFINITY, to));
        return this;
    }

    public RangeFacetBuilder addUnboundedFrom(String to) {
        this.entries.add(new Entry(null, to));
        return this;
    }

    @Override
    public RangeFacetBuilder global(boolean global) {
        super.global(global);
        return this;
    }

    @Override
    public RangeFacetBuilder scope(String scope) {
        super.scope(scope);
        return this;
    }

    @Override
    public RangeFacetBuilder facetFilter(FilterBuilder filter) {
        this.facetFilter = filter;
        return this;
    }

    @Override
    public RangeFacetBuilder nested(String nested) {
        this.nested = nested;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (this.keyFieldName == null) {
            throw new SearchSourceBuilderException("field must be set on range facet for facet [" + this.name + "]");
        }
        if (this.entries.isEmpty()) {
            throw new SearchSourceBuilderException("at least one range must be defined for range facet [" + this.name + "]");
        }
        builder.startObject(this.name);
        builder.startObject("range");
        if (this.valueFieldName != null && !this.keyFieldName.equals(this.valueFieldName)) {
            builder.field("key_field", this.keyFieldName);
            builder.field("value_field", this.valueFieldName);
        } else {
            builder.field("field", this.keyFieldName);
        }
        builder.startArray("ranges");
        for (Entry entry : this.entries) {
            builder.startObject();
            if (entry.fromAsString != null) {
                builder.field("from", entry.fromAsString);
            } else if (!Double.isInfinite(entry.from)) {
                builder.field("from", entry.from);
            }
            if (entry.toAsString != null) {
                builder.field("to", entry.toAsString);
            } else if (!Double.isInfinite(entry.to)) {
                builder.field("to", entry.to);
            }
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        this.addFilterFacetAndGlobal(builder, params2);
        builder.endObject();
        return builder;
    }

    static class Entry {
        double from = Double.NEGATIVE_INFINITY;
        double to = Double.POSITIVE_INFINITY;
        String fromAsString;
        String toAsString;

        Entry(String fromAsString, String toAsString) {
            this.fromAsString = fromAsString;
            this.toAsString = toAsString;
        }

        Entry(double from, double to) {
            this.from = from;
            this.to = to;
        }
    }
}

