/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.query;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.query.QueryFacet;

public class InternalQueryFacet
implements QueryFacet,
InternalFacet {
    private static final String STREAM_TYPE = "query";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type2, StreamInput in) throws IOException {
            return InternalQueryFacet.readQueryFacet(in);
        }
    };
    private String name;
    private long count;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalQueryFacet() {
    }

    public InternalQueryFacet(String name2, long count2) {
        this.name = name2;
        this.count = count2;
    }

    @Override
    public String type() {
        return STREAM_TYPE;
    }

    @Override
    public String getType() {
        return STREAM_TYPE;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, STREAM_TYPE);
        builder.field(Fields.COUNT, this.count);
        builder.endObject();
        return builder;
    }

    public static QueryFacet readQueryFacet(StreamInput in) throws IOException {
        InternalQueryFacet result2 = new InternalQueryFacet();
        result2.readFrom(in);
        return result2;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.count = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeVLong(this.count);
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }
}

