/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;

public class InternalGeoDistanceFacet
implements GeoDistanceFacet,
InternalFacet {
    private static final String STREAM_TYPE = "geoDistance";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type2, StreamInput in) throws IOException {
            return InternalGeoDistanceFacet.readGeoDistanceFacet(in);
        }
    };
    private String name;
    GeoDistanceFacet.Entry[] entries;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    InternalGeoDistanceFacet() {
    }

    public InternalGeoDistanceFacet(String name2, GeoDistanceFacet.Entry[] entries2) {
        this.name = name2;
        this.entries = entries2;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return "geo_distance";
    }

    @Override
    public String getType() {
        return this.type();
    }

    @Override
    public List<GeoDistanceFacet.Entry> entries() {
        return ImmutableList.copyOf(this.entries);
    }

    @Override
    public List<GeoDistanceFacet.Entry> getEntries() {
        return this.entries();
    }

    @Override
    public Iterator<GeoDistanceFacet.Entry> iterator() {
        return this.entries().iterator();
    }

    public static InternalGeoDistanceFacet readGeoDistanceFacet(StreamInput in) throws IOException {
        InternalGeoDistanceFacet facet = new InternalGeoDistanceFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.entries = new GeoDistanceFacet.Entry[in.readVInt()];
        for (int i2 = 0; i2 < this.entries.length; ++i2) {
            this.entries[i2] = new GeoDistanceFacet.Entry(in.readDouble(), in.readDouble(), in.readVLong(), in.readVLong(), in.readDouble(), in.readDouble(), in.readDouble());
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeVInt(this.entries.length);
        for (GeoDistanceFacet.Entry entry : this.entries) {
            out.writeDouble(entry.from);
            out.writeDouble(entry.to);
            out.writeVLong(entry.count);
            out.writeVLong(entry.totalCount);
            out.writeDouble(entry.total);
            out.writeDouble(entry.min);
            out.writeDouble(entry.max);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, "geo_distance");
        builder.startArray(Fields.RANGES);
        for (GeoDistanceFacet.Entry entry : this.entries) {
            builder.startObject();
            if (!Double.isInfinite(entry.from)) {
                builder.field(Fields.FROM, entry.from);
            }
            if (!Double.isInfinite(entry.to)) {
                builder.field(Fields.TO, entry.to);
            }
            builder.field(Fields.MIN, entry.min());
            builder.field(Fields.MAX, entry.max());
            builder.field(Fields.TOTAL_COUNT, entry.totalCount());
            builder.field(Fields.TOTAL, entry.total());
            builder.field(Fields.MEAN, entry.mean());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString RANGES = new XContentBuilderString("ranges");
        static final XContentBuilderString FROM = new XContentBuilderString("from");
        static final XContentBuilderString TO = new XContentBuilderString("to");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL_COUNT = new XContentBuilderString("total_count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");

        Fields() {
        }
    }
}

