/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.index.search.geo.GeoHashUtils;
import org.elasticsearch.index.search.geo.GeoUtils;
import org.elasticsearch.index.search.geo.Point;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.FacetProcessor;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetCollector;
import org.elasticsearch.search.facet.geodistance.InternalGeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.ScriptGeoDistanceFacetCollector;
import org.elasticsearch.search.facet.geodistance.ValueGeoDistanceFacetCollector;
import org.elasticsearch.search.internal.SearchContext;

public class GeoDistanceFacetProcessor
extends AbstractComponent
implements FacetProcessor {
    @Inject
    public GeoDistanceFacetProcessor(Settings settings) {
        super(settings);
        InternalGeoDistanceFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"geo_distance", "geoDistance"};
    }

    @Override
    public FacetCollector parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        String valueFieldName = null;
        String valueScript = null;
        String scriptLang = null;
        Map<String, Object> params2 = null;
        double lat = Double.NaN;
        double lon = Double.NaN;
        DistanceUnit unit = DistanceUnit.KILOMETERS;
        GeoDistance geoDistance = GeoDistance.ARC;
        ArrayList<GeoDistanceFacet.Entry> entries2 = Lists.newArrayList();
        boolean normalizeLon = true;
        boolean normalizeLat = true;
        String currentName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("ranges".equals(currentName) || "entries".equals(currentName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        double from = Double.NEGATIVE_INFINITY;
                        double to = Double.POSITIVE_INFINITY;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("from".equals(currentName)) {
                                from = parser.doubleValue();
                                continue;
                            }
                            if (!"to".equals(currentName)) continue;
                            to = parser.doubleValue();
                        }
                        entries2.add(new GeoDistanceFacet.Entry(from, to, 0L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY));
                    }
                    continue;
                }
                token = parser.nextToken();
                lon = parser.doubleValue();
                token = parser.nextToken();
                lat = parser.doubleValue();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                }
                fieldName = currentName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentName)) {
                    params2 = parser.map();
                    continue;
                }
                fieldName = currentName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentName = parser.currentName();
                        continue;
                    }
                    if (!token.isValue()) continue;
                    if (currentName.equals("lat")) {
                        lat = parser.doubleValue();
                        continue;
                    }
                    if (currentName.equals("lon")) {
                        lon = parser.doubleValue();
                        continue;
                    }
                    if (!currentName.equals("geohash")) continue;
                    double[] values2 = GeoHashUtils.decode(parser.text());
                    lat = values2[0];
                    lon = values2[1];
                }
                continue;
            }
            if (!token.isValue()) continue;
            if (currentName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentName.equals("distance_type") || currentName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if ("value_field".equals(currentName) || "valueField".equals(currentName)) {
                valueFieldName = parser.text();
                continue;
            }
            if ("value_script".equals(currentName) || "valueScript".equals(currentName)) {
                valueScript = parser.text();
                continue;
            }
            if ("lang".equals(currentName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("normalize".equals(currentName)) {
                normalizeLat = parser.booleanValue();
                normalizeLon = parser.booleanValue();
                continue;
            }
            String value2 = parser.text();
            int comma = value2.indexOf(44);
            if (comma != -1) {
                lat = Double.parseDouble(value2.substring(0, comma).trim());
                lon = Double.parseDouble(value2.substring(comma + 1).trim());
            } else {
                double[] values3 = GeoHashUtils.decode(value2);
                lat = values3[0];
                lon = values3[1];
            }
            fieldName = currentName;
        }
        if (Double.isNaN(lat) || Double.isNaN(lon)) {
            throw new FacetPhaseExecutionException(facetName, "lat/lon not set for geo_distance facet");
        }
        if (entries2.isEmpty()) {
            throw new FacetPhaseExecutionException(facetName, "no ranges defined for geo_distance facet");
        }
        if (normalizeLat || normalizeLon) {
            Point point = new Point(lat, lon);
            GeoUtils.normalizePoint(point, normalizeLat, normalizeLon);
            lat = point.lat;
            lon = point.lon;
        }
        if (valueFieldName != null) {
            return new ValueGeoDistanceFacetCollector(facetName, fieldName, lat, lon, unit, geoDistance, entries2.toArray(new GeoDistanceFacet.Entry[entries2.size()]), context, valueFieldName);
        }
        if (valueScript != null) {
            return new ScriptGeoDistanceFacetCollector(facetName, fieldName, lat, lon, unit, geoDistance, entries2.toArray(new GeoDistanceFacet.Entry[entries2.size()]), context, scriptLang, valueScript, params2);
        }
        return new GeoDistanceFacetCollector(facetName, fieldName, lat, lon, unit, geoDistance, entries2.toArray(new GeoDistanceFacet.Entry[entries2.size()]), context);
    }

    @Override
    public Facet reduce(String name2, List<Facet> facets) {
        InternalGeoDistanceFacet agg = null;
        for (Facet facet : facets) {
            InternalGeoDistanceFacet geoDistanceFacet = (InternalGeoDistanceFacet)facet;
            if (agg == null) {
                agg = geoDistanceFacet;
                continue;
            }
            for (int i2 = 0; i2 < geoDistanceFacet.entries.length; ++i2) {
                GeoDistanceFacet.Entry aggEntry = agg.entries[i2];
                GeoDistanceFacet.Entry currentEntry = geoDistanceFacet.entries[i2];
                aggEntry.count += currentEntry.count;
                aggEntry.totalCount += currentEntry.totalCount;
                aggEntry.total += currentEntry.total;
                if (currentEntry.min < aggEntry.min) {
                    aggEntry.min = currentEntry.min;
                }
                if (!(currentEntry.max > aggEntry.max)) continue;
                aggEntry.max = currentEntry.max;
            }
        }
        return agg;
    }
}

