/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.util.Comparator;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.search.facet.Facet;

public interface DateHistogramFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "date_histogram";

    public List<? extends Entry> entries();

    public List<? extends Entry> getEntries();

    public static interface Entry {
        public long time();

        public long getTime();

        public long count();

        public long getCount();

        public long totalCount();

        public long getTotalCount();

        public double total();

        public double getTotal();

        public double mean();

        public double getMean();

        public double min();

        public double getMin();

        public double max();

        public double getMax();
    }

    public static enum ComparatorType {
        TIME(0, "time", new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.time() < o2.time() ? -1 : (o1.time() == o2.time() ? 0 : 1);
            }
        }),
        COUNT(1, "count", new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.count() < o2.count() ? -1 : (o1.count() == o2.count() ? 0 : 1);
            }
        }),
        TOTAL(2, "total", new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                if (o1 == null) {
                    if (o2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (o2 == null) {
                    return -1;
                }
                return o1.total() < o2.total() ? -1 : (o1.total() == o2.total() ? 0 : 1);
            }
        });

        private final byte id;
        private final String description;
        private final Comparator<Entry> comparator;

        private ComparatorType(byte id2, String description, Comparator<Entry> comparator) {
            this.id = id2;
            this.description = description;
            this.comparator = comparator;
        }

        public byte id() {
            return this.id;
        }

        public String description() {
            return this.description;
        }

        public Comparator<Entry> comparator() {
            return this.comparator;
        }

        public static ComparatorType fromId(byte id2) {
            if (id2 == 0) {
                return TIME;
            }
            if (id2 == 1) {
                return COUNT;
            }
            if (id2 == 2) {
                return TOTAL;
            }
            throw new ElasticSearchIllegalArgumentException("No type argument match for histogram comparator [" + id2 + "]");
        }

        public static ComparatorType fromString(String type2) {
            if ("time".equals(type2)) {
                return TIME;
            }
            if ("count".equals(type2)) {
                return COUNT;
            }
            if ("total".equals(type2)) {
                return TOTAL;
            }
            throw new ElasticSearchIllegalArgumentException("No type argument match for histogram comparator [" + type2 + "]");
        }
    }
}

