/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class SearchShardTarget
implements Streamable,
Serializable,
Comparable<SearchShardTarget> {
    private String nodeId;
    private String index;
    private int shardId;

    private SearchShardTarget() {
    }

    public SearchShardTarget(String nodeId, String index2, int shardId) {
        this.nodeId = nodeId;
        this.index = index2;
        this.shardId = shardId;
    }

    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    @Nullable
    public String getNodeId() {
        return this.nodeId;
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index;
    }

    public int shardId() {
        return this.shardId;
    }

    public int getShardId() {
        return this.shardId;
    }

    public static SearchShardTarget readSearchShardTarget(StreamInput in) throws IOException {
        SearchShardTarget result2 = new SearchShardTarget();
        result2.readFrom(in);
        return result2;
    }

    @Override
    public int compareTo(SearchShardTarget o) {
        int i2 = this.index.compareTo(o.index());
        if (i2 == 0) {
            i2 = this.shardId - o.shardId;
        }
        return i2;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.nodeId = in.readUTF();
        }
        this.index = in.readUTF();
        this.shardId = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.nodeId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.nodeId);
        }
        out.writeUTF(this.index);
        out.writeVInt(this.shardId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardTarget that = (SearchShardTarget)o;
        if (this.shardId != that.shardId) {
            return false;
        }
        if (this.index != null ? !this.index.equals(that.index) : that.index != null) {
            return false;
        }
        return !(this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null);
    }

    public int hashCode() {
        int result2 = this.nodeId != null ? this.nodeId.hashCode() : 0;
        result2 = 31 * result2 + (this.index != null ? this.index.hashCode() : 0);
        result2 = 31 * result2 + this.shardId;
        return result2;
    }

    public String toString() {
        if (this.nodeId == null) {
            return "[_na_][" + this.index + "][" + this.shardId + "]";
        }
        return "[" + this.nodeId + "][" + this.index + "][" + this.shardId + "]";
    }
}

