/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.cluster;

import java.io.IOException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.river.cluster.RiverClusterState;
import org.elasticsearch.river.cluster.RiverNodeHelper;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class PublishRiverClusterStateAction
extends AbstractComponent {
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final NewClusterStateListener listener;

    public PublishRiverClusterStateAction(Settings settings, TransportService transportService, ClusterService clusterService, NewClusterStateListener listener) {
        super(settings);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.listener = listener;
        transportService.registerHandler("river/state/publish", new PublishClusterStateRequestHandler());
    }

    public void close() {
        this.transportService.removeHandler("river/state/publish");
    }

    public void publish(RiverClusterState clusterState) {
        DiscoveryNodes discoNodes = this.clusterService.state().nodes();
        for (final DiscoveryNode node : discoNodes) {
            if (node.equals(discoNodes.localNode()) || !node.masterNode() && !RiverNodeHelper.isRiverNode(node)) continue;
            this.transportService.sendRequest(node, "river/state/publish", new PublishClusterStateRequest(clusterState), new EmptyTransportResponseHandler("same"){

                @Override
                public void handleException(TransportException exp2) {
                    PublishRiverClusterStateAction.this.logger.debug("failed to send cluster state to [{}], should be detected as failed soon...", exp2, node);
                }
            });
        }
    }

    private class PublishClusterStateRequestHandler
    extends BaseTransportRequestHandler<PublishClusterStateRequest> {
        static final String ACTION = "river/state/publish";

        private PublishClusterStateRequestHandler() {
        }

        @Override
        public PublishClusterStateRequest newInstance() {
            return new PublishClusterStateRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(PublishClusterStateRequest request, TransportChannel channel) throws Exception {
            PublishRiverClusterStateAction.this.listener.onNewClusterState(request.clusterState);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    private class PublishClusterStateRequest
    extends TransportRequest {
        private RiverClusterState clusterState;

        private PublishClusterStateRequest() {
        }

        private PublishClusterStateRequest(RiverClusterState clusterState) {
            this.clusterState = clusterState;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.clusterState = RiverClusterState.Builder.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            RiverClusterState.Builder.writeTo(this.clusterState, out);
        }
    }

    public static interface NewClusterStateListener {
        public void onNewClusterState(RiverClusterState var1);
    }
}

