/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river;

import java.util.Map;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.river.RiverIndexName;
import org.elasticsearch.river.RiversManager;
import org.elasticsearch.river.RiversService;
import org.elasticsearch.river.RiversTypesRegistry;
import org.elasticsearch.river.cluster.RiverClusterService;
import org.elasticsearch.river.routing.RiversRouter;

public class RiversModule
extends AbstractModule {
    private final Settings settings;
    private Map<String, Class<? extends Module>> riverTypes = Maps.newHashMap();

    public RiversModule(Settings settings) {
        this.settings = settings;
    }

    public void registerRiver(String type2, Class<? extends Module> module) {
        this.riverTypes.put(type2, module);
    }

    @Override
    protected void configure() {
        this.bind(String.class).annotatedWith(RiverIndexName.class).toInstance(RiverIndexName.Conf.indexName(this.settings));
        this.bind(RiversService.class).asEagerSingleton();
        this.bind(RiverClusterService.class).asEagerSingleton();
        this.bind(RiversRouter.class).asEagerSingleton();
        this.bind(RiversManager.class).asEagerSingleton();
        this.bind(RiversTypesRegistry.class).toInstance(new RiversTypesRegistry(ImmutableMap.copyOf(this.riverTypes)));
    }
}

