/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.support;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.support.RestUtils;

public abstract class AbstractRestRequest
implements RestRequest {
    @Override
    public final String path() {
        return RestUtils.decodeComponent(this.rawPath());
    }

    @Override
    public float paramAsFloat(String key2, float defaultValue) {
        String sValue = this.param(key2);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(sValue);
        }
        catch (NumberFormatException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to parse float parameter [" + key2 + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public int paramAsInt(String key2, int defaultValue) {
        String sValue = this.param(key2);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to parse int parameter [" + key2 + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public long paramAsLong(String key2, long defaultValue) {
        String sValue = this.param(key2);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to parse int parameter [" + key2 + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public boolean paramAsBoolean(String key2, boolean defaultValue) {
        return Booleans.parseBoolean(this.param(key2), defaultValue);
    }

    @Override
    public Boolean paramAsBooleanOptional(String key2, Boolean defaultValue) {
        String sValue = this.param(key2);
        if (sValue == null) {
            return defaultValue;
        }
        return !sValue.equals("false") && !sValue.equals("0") && !sValue.equals("off");
    }

    @Override
    public TimeValue paramAsTime(String key2, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.param(key2), defaultValue);
    }

    @Override
    public ByteSizeValue paramAsSize(String key2, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue(this.param(key2), defaultValue);
    }

    @Override
    public String[] paramAsStringArray(String key2, String[] defaultValue) {
        String value2 = this.param(key2);
        if (value2 == null) {
            return defaultValue;
        }
        return Strings.splitStringByCommaToArray(value2);
    }
}

