/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.node.info;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestNodesInfoAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestNodesInfoAction(Settings settings, Client client, RestController controller, SettingsFilter settingsFilter) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/nodes", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/nodes/{nodeId}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/settings", new RestSettingsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/settings", new RestSettingsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/os", new RestOsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/os", new RestOsHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/process", new RestProcessHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/process", new RestProcessHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/jvm", new RestJvmHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/jvm", new RestJvmHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/thread_pool", new RestThreadPoolHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/thread_pool", new RestThreadPoolHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/network", new RestNetworkHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/network", new RestNetworkHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/transport", new RestTransportHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/transport", new RestTransportHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/http", new RestHttpHandler());
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/http", new RestHttpHandler());
        this.settingsFilter = settingsFilter;
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        boolean all;
        String[] nodesIds = RestActions.splitNodes(request.param("nodeId"));
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(nodesIds);
        boolean clear2 = request.paramAsBoolean("clear", false);
        if (clear2) {
            nodesInfoRequest.clear();
        }
        if (all = request.paramAsBoolean("all", false)) {
            nodesInfoRequest.all();
        }
        nodesInfoRequest.settings(request.paramAsBoolean("settings", nodesInfoRequest.settings()));
        nodesInfoRequest.os(request.paramAsBoolean("os", nodesInfoRequest.os()));
        nodesInfoRequest.process(request.paramAsBoolean("process", nodesInfoRequest.process()));
        nodesInfoRequest.jvm(request.paramAsBoolean("jvm", nodesInfoRequest.jvm()));
        nodesInfoRequest.threadPool(request.paramAsBoolean("thread_pool", nodesInfoRequest.threadPool()));
        nodesInfoRequest.network(request.paramAsBoolean("network", nodesInfoRequest.network()));
        nodesInfoRequest.transport(request.paramAsBoolean("transport", nodesInfoRequest.transport()));
        nodesInfoRequest.http(request.paramAsBoolean("http", nodesInfoRequest.http()));
        this.executeNodeRequest(request, channel, nodesInfoRequest);
    }

    void executeNodeRequest(final RestRequest request, final RestChannel channel, NodesInfoRequest nodesInfoRequest) {
        nodesInfoRequest.listenerThreaded(false);
        this.client.admin().cluster().nodesInfo(nodesInfoRequest, new ActionListener<NodesInfoResponse>(){

            @Override
            public void onResponse(NodesInfoResponse response) {
                try {
                    response.settingsFilter(RestNodesInfoAction.this.settingsFilter);
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("ok", true);
                    response.toXContent(builder, request);
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestNodesInfoAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    class RestHttpHandler
    implements RestHandler {
        RestHttpHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(RestActions.splitNodes(request.param("nodeId")));
            nodesInfoRequest.clear().http(true);
            RestNodesInfoAction.this.executeNodeRequest(request, channel, nodesInfoRequest);
        }
    }

    class RestTransportHandler
    implements RestHandler {
        RestTransportHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(RestActions.splitNodes(request.param("nodeId")));
            nodesInfoRequest.clear().transport(true);
            RestNodesInfoAction.this.executeNodeRequest(request, channel, nodesInfoRequest);
        }
    }

    class RestNetworkHandler
    implements RestHandler {
        RestNetworkHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(RestActions.splitNodes(request.param("nodeId")));
            nodesInfoRequest.clear().network(true);
            RestNodesInfoAction.this.executeNodeRequest(request, channel, nodesInfoRequest);
        }
    }

    class RestThreadPoolHandler
    implements RestHandler {
        RestThreadPoolHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(RestActions.splitNodes(request.param("nodeId")));
            nodesInfoRequest.clear().threadPool(true);
            RestNodesInfoAction.this.executeNodeRequest(request, channel, nodesInfoRequest);
        }
    }

    class RestJvmHandler
    implements RestHandler {
        RestJvmHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(RestActions.splitNodes(request.param("nodeId")));
            nodesInfoRequest.clear().jvm(true);
            RestNodesInfoAction.this.executeNodeRequest(request, channel, nodesInfoRequest);
        }
    }

    class RestProcessHandler
    implements RestHandler {
        RestProcessHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(RestActions.splitNodes(request.param("nodeId")));
            nodesInfoRequest.clear().process(true);
            RestNodesInfoAction.this.executeNodeRequest(request, channel, nodesInfoRequest);
        }
    }

    class RestOsHandler
    implements RestHandler {
        RestOsHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(RestActions.splitNodes(request.param("nodeId")));
            nodesInfoRequest.clear().os(true);
            RestNodesInfoAction.this.executeNodeRequest(request, channel, nodesInfoRequest);
        }
    }

    class RestSettingsHandler
    implements RestHandler {
        RestSettingsHandler() {
        }

        @Override
        public void handleRequest(RestRequest request, RestChannel channel) {
            NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(RestActions.splitNodes(request.param("nodeId")));
            nodesInfoRequest.clear().settings(true);
            RestNodesInfoAction.this.executeNodeRequest(request, channel, nodesInfoRequest);
        }
    }
}

