/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class XContentThrowableRestResponse
extends XContentRestResponse {
    public XContentThrowableRestResponse(RestRequest request, Throwable t) throws IOException {
        this(request, t instanceof ElasticSearchException ? ((ElasticSearchException)t).status() : RestStatus.INTERNAL_SERVER_ERROR, t);
    }

    public XContentThrowableRestResponse(RestRequest request, RestStatus status2, Throwable t) throws IOException {
        super(request, status2, XContentThrowableRestResponse.convert(request, status2, t));
    }

    private static XContentBuilder convert(RestRequest request, RestStatus status2, Throwable t) throws IOException {
        XContentBuilder builder = RestXContentBuilder.restContentBuilder(request).startObject().field("error", ExceptionsHelper.detailedMessage(t)).field("status", status2.getStatus());
        if (t != null && request.paramAsBoolean("error_trace", false)) {
            builder.startObject("error_trace");
            boolean first2 = true;
            while (t != null) {
                if (!first2) {
                    builder.startObject("cause");
                }
                XContentThrowableRestResponse.buildThrowable(t, builder);
                if (!first2) {
                    builder.endObject();
                }
                t = t.getCause();
                first2 = false;
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static void buildThrowable(Throwable t, XContentBuilder builder) throws IOException {
        builder.field("message", t.getMessage());
        for (StackTraceElement stElement : t.getStackTrace()) {
            builder.startObject("at").field("class", stElement.getClassName()).field("method", stElement.getMethodName());
            if (stElement.getFileName() != null) {
                builder.field("file", stElement.getFileName());
            }
            if (stElement.getLineNumber() >= 0) {
                builder.field("line", stElement.getLineNumber());
            }
            builder.endObject();
        }
    }
}

