/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.dump.summary;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.dump.Dump;
import org.elasticsearch.monitor.dump.DumpContributionFailedException;
import org.elasticsearch.monitor.dump.DumpContributor;

public class SummaryDumpContributor
implements DumpContributor {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final Object formatterLock = new Object();
    public static final String SUMMARY = "summary";
    private final String name;

    @Inject
    public SummaryDumpContributor(@Assisted String name2, @Assisted Settings settings) {
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void contribute(Dump dump2) throws DumpContributionFailedException {
        PrintWriter writer = new PrintWriter(dump2.createFileWriter("summary.txt"));
        try {
            this.processHeader(writer, dump2.timestamp());
            this.processCause(writer, dump2.cause());
            this.processThrowables(writer, dump2);
        }
        catch (Exception e) {
            throw new DumpContributionFailedException(this.getName(), "Failed to generate", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHeader(PrintWriter writer, long timestamp) {
        Object object = this.formatterLock;
        synchronized (object) {
            writer.println("===== TIME =====");
            writer.println(this.dateFormat.format(new Date(timestamp)));
            writer.println();
        }
    }

    private void processCause(PrintWriter writer, String cause2) {
        writer.println("===== CAUSE =====");
        writer.println(cause2);
        writer.println();
    }

    private void processThrowables(PrintWriter writer, Dump dump2) {
        writer.println("===== EXCEPTIONS =====");
        Object throwables = dump2.context().get("throwables");
        if (throwables == null) {
            return;
        }
        if (throwables instanceof Throwable[]) {
            Throwable[] array;
            for (Throwable t : array = (Throwable[])throwables) {
                writer.println();
                writer.println("---- Exception ----");
                t.printStackTrace(writer);
            }
        } else if (throwables instanceof Collection) {
            Collection collection = (Collection)throwables;
            for (Object o : collection) {
                Throwable t = (Throwable)o;
                writer.println();
                writer.println("---- Exception ----");
                t.printStackTrace(writer);
            }
        } else {
            throw new DumpContributionFailedException(this.getName(), "Can't handle throwables type [" + throwables.getClass() + "]");
        }
        writer.println();
    }
}

