/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.dump.cluster;

import java.io.PrintWriter;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.dump.Dump;
import org.elasticsearch.monitor.dump.DumpContributionFailedException;
import org.elasticsearch.monitor.dump.DumpContributor;

public class ClusterDumpContributor
implements DumpContributor {
    public static final String CLUSTER = "cluster";
    private final String name;
    private final ClusterService clusterService;

    @Inject
    public ClusterDumpContributor(ClusterService clusterService, @Assisted String name2, @Assisted Settings settings) {
        this.clusterService = clusterService;
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void contribute(Dump dump2) throws DumpContributionFailedException {
        ClusterState clusterState = this.clusterService.state();
        DiscoveryNodes nodes = clusterState.nodes();
        RoutingTable routingTable = clusterState.routingTable();
        PrintWriter writer = new PrintWriter(dump2.createFileWriter("cluster.txt"));
        writer.println("===== CLUSTER NODES ======");
        writer.print(nodes.prettyPrint());
        writer.println("===== ROUTING TABLE ======");
        writer.print(routingTable.prettyPrint());
        writer.close();
    }
}

