/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.store;

import java.io.File;
import org.apache.lucene.store.StoreRateLimiting;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesStore
extends AbstractComponent
implements ClusterStateListener {
    public static final String INDICES_STORE_THROTTLE_TYPE = "indices.store.throttle.type";
    public static final String INDICES_STORE_THROTTLE_MAX_BYTES_PER_SEC = "indices.store.throttle.max_bytes_per_sec";
    private final NodeEnvironment nodeEnv;
    private final NodeSettingsService nodeSettingsService;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private volatile String rateLimitingType;
    private volatile ByteSizeValue rateLimitingThrottle;
    private final StoreRateLimiting rateLimiting = new StoreRateLimiting();
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public IndicesStore(Settings settings, NodeEnvironment nodeEnv, NodeSettingsService nodeSettingsService, IndicesService indicesService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.nodeSettingsService = nodeSettingsService;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.rateLimitingType = this.componentSettings.get("throttle.type", "none");
        this.rateLimiting.setType(this.rateLimitingType);
        this.rateLimitingThrottle = this.componentSettings.getAsBytesSize("throttle.max_bytes_per_sec", new ByteSizeValue(0L));
        this.rateLimiting.setMaxRate(this.rateLimitingThrottle);
        this.logger.debug("using indices.store.throttle.type [{}], with index.store.throttle.max_bytes_per_sec [{}]", this.rateLimitingType, this.rateLimitingThrottle);
        nodeSettingsService.addListener(this.applySettings);
        clusterService.addLast(this);
    }

    public StoreRateLimiting rateLimiting() {
        return this.rateLimiting;
    }

    public void close() {
        this.nodeSettingsService.removeListener(this.applySettings);
        this.clusterService.remove(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.routingTableChanged()) {
            return;
        }
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        for (IndexRoutingTable indexRoutingTable : event.state().routingTable()) {
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                ShardId shardId = indexShardRoutingTable.shardId();
                boolean shardCanBeDeleted = true;
                if (indexShardRoutingTable.size() == 0) {
                    shardCanBeDeleted = false;
                } else {
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        if (!shardRouting.started()) {
                            shardCanBeDeleted = false;
                            break;
                        }
                        String localNodeId = this.clusterService.localNode().id();
                        if (!localNodeId.equals(shardRouting.currentNodeId()) && !localNodeId.equals(shardRouting.relocatingNodeId())) continue;
                        shardCanBeDeleted = false;
                        break;
                    }
                }
                if (!shardCanBeDeleted) continue;
                IndexService indexService = this.indicesService.indexService(indexRoutingTable.index());
                if (indexService == null) {
                    File[] shardLocations;
                    if (!this.nodeEnv.hasNodeFile() || !FileSystemUtils.exists(shardLocations = this.nodeEnv.shardLocations(shardId))) continue;
                    this.logger.debug("[{}][{}] deleting shard that is no longer used", shardId.index().name(), shardId.id());
                    FileSystemUtils.deleteRecursively(shardLocations);
                    continue;
                }
                if (indexService.hasShard(shardId.id()) || !indexService.store().canDeleteUnallocated(shardId)) continue;
                this.logger.debug("[{}][{}] deleting shard that is no longer used", shardId.index().name(), shardId.id());
                try {
                    indexService.store().deleteUnallocated(indexShardRoutingTable.shardId());
                }
                catch (Exception e) {
                    this.logger.debug("[{}][{}] failed to delete unallocated shard, ignoring", e, indexShardRoutingTable.shardId().index().name(), indexShardRoutingTable.shardId().id());
                }
            }
        }
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            ByteSizeValue rateLimitingThrottle;
            String rateLimitingType = settings.get(IndicesStore.INDICES_STORE_THROTTLE_TYPE, IndicesStore.this.rateLimitingType);
            StoreRateLimiting.Type.fromString(rateLimitingType);
            if (!rateLimitingType.equals(IndicesStore.this.rateLimitingType)) {
                IndicesStore.this.logger.info("updating indices.store.throttle.type from [{}] to [{}]", IndicesStore.this.rateLimitingType, rateLimitingType);
                IndicesStore.this.rateLimitingType = rateLimitingType;
                IndicesStore.this.rateLimiting.setType(rateLimitingType);
            }
            if (!(rateLimitingThrottle = settings.getAsBytesSize(IndicesStore.INDICES_STORE_THROTTLE_MAX_BYTES_PER_SEC, IndicesStore.this.rateLimitingThrottle)).equals(IndicesStore.this.rateLimitingThrottle)) {
                IndicesStore.this.logger.info("updating indices.store.throttle.max_bytes_per_sec from [{}] to [{}], note, type is [{}]", IndicesStore.this.rateLimitingThrottle, rateLimitingThrottle, IndicesStore.this.rateLimitingType);
                IndicesStore.this.rateLimitingThrottle = rateLimitingThrottle;
                IndicesStore.this.rateLimiting.setMaxRate(rateLimitingThrottle);
            }
        }
    }
}

