/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.memory;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.bytebuffer.ByteBufferAllocator;
import org.apache.lucene.store.bytebuffer.ByteBufferDirectory;
import org.apache.lucene.store.bytebuffer.ByteBufferFile;
import org.elasticsearch.cache.memory.ByteBufferCache;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;

public class ByteBufferDirectoryService
extends AbstractIndexShardComponent
implements DirectoryService {
    private final ByteBufferCache byteBufferCache;

    @Inject
    public ByteBufferDirectoryService(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore, ByteBufferCache byteBufferCache) {
        super(shardId, indexSettings);
        this.byteBufferCache = byteBufferCache;
    }

    @Override
    public long throttleTimeInNanos() {
        return 0L;
    }

    @Override
    public Directory[] build() {
        return new Directory[]{new CustomByteBufferDirectory(this.byteBufferCache)};
    }

    @Override
    public void renameFile(Directory dir, String from, String to) throws IOException {
        ((CustomByteBufferDirectory)dir).renameTo(from, to);
    }

    @Override
    public void fullDelete(Directory dir) {
    }

    static class CustomByteBufferDirectory
    extends ByteBufferDirectory {
        CustomByteBufferDirectory() {
        }

        CustomByteBufferDirectory(ByteBufferAllocator allocator) {
            super(allocator);
        }

        public void renameTo(String from, String to) throws IOException {
            ByteBufferFile fromFile = (ByteBufferFile)this.files.get(from);
            if (fromFile == null) {
                throw new FileNotFoundException(from);
            }
            ByteBufferFile toFile = (ByteBufferFile)this.files.get(to);
            if (toFile != null) {
                this.files.remove(from);
            }
            this.files.put(to, fromFile);
        }
    }
}

