/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Adler32;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.compress.CompressedIndexOutput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.Directories;
import org.elasticsearch.common.lucene.store.BufferedChecksumIndexOutput;
import org.elasticsearch.common.lucene.store.ChecksumIndexOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.store.support.ForceSyncDirectory;

public class Store
extends AbstractIndexShardComponent {
    public static final String INDEX_STORE_COMPRESS_STORED = "index.store.compress.stored";
    public static final String INDEX_STORE_COMPRESS_TV = "index.store.compress.tv";
    static final String CHECKSUMS_PREFIX = "_checksums-";
    private final IndexStore indexStore;
    private final IndexSettingsService indexSettingsService;
    private final DirectoryService directoryService;
    private final StoreDirectory directory;
    private volatile ImmutableMap<String, StoreFileMetaData> filesMetadata = ImmutableMap.of();
    private volatile String[] files = Strings.EMPTY_ARRAY;
    private final Object mutex = new Object();
    private final boolean sync;
    private volatile boolean compressStored;
    private volatile boolean compressTv;
    private final ApplySettings applySettings = new ApplySettings();

    public static final boolean isChecksum(String name2) {
        return name2.startsWith(CHECKSUMS_PREFIX);
    }

    @Inject
    public Store(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore, IndexSettingsService indexSettingsService, DirectoryService directoryService) throws IOException {
        super(shardId, indexSettings);
        this.indexStore = indexStore;
        this.indexSettingsService = indexSettingsService;
        this.directoryService = directoryService;
        this.sync = this.componentSettings.getAsBoolean("sync", true);
        this.directory = new StoreDirectory(directoryService.build());
        this.compressStored = this.componentSettings.getAsBoolean("compress.stored", false);
        this.compressTv = this.componentSettings.getAsBoolean("compress.tv", false);
        this.logger.debug("using compress.stored [{}], compress.tv [{}]", this.compressStored, this.compressTv);
        indexSettingsService.addListener(this.applySettings);
    }

    public IndexStore indexStore() {
        return this.indexStore;
    }

    public Directory directory() {
        return this.directory;
    }

    public ImmutableMap<String, StoreFileMetaData> list() throws IOException {
        ImmutableMap.Builder<String, StoreFileMetaData> builder = ImmutableMap.builder();
        for (String name2 : this.files) {
            StoreFileMetaData md = this.metaData(name2);
            if (md == null) continue;
            builder.put(md.name(), md);
        }
        return builder.build();
    }

    public StoreFileMetaData metaData(String name2) throws IOException {
        StoreFileMetaData md = this.filesMetadata.get(name2);
        if (md == null) {
            return null;
        }
        if (md.lastModified() == -1L || md.length() == -1L) {
            return null;
        }
        return md;
    }

    public void deleteContent() throws IOException {
        String[] files = this.directory.listAll();
        IOException lastException = null;
        for (String file2 : files) {
            if (Store.isChecksum(file2)) {
                try {
                    this.directory.deleteFileChecksum(file2);
                }
                catch (IOException e) {
                    lastException = e;
                }
                continue;
            }
            try {
                this.directory.deleteFile(file2);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    public void fullDelete() throws IOException {
        this.deleteContent();
        for (Directory delegate2 : this.directory.delegates()) {
            this.directoryService.fullDelete(delegate2);
        }
    }

    public StoreStats stats() throws IOException {
        return new StoreStats(Directories.estimateSize(this.directory), this.directoryService.throttleTimeInNanos());
    }

    public ByteSizeValue estimateSize() throws IOException {
        return new ByteSizeValue(Directories.estimateSize(this.directory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFile(String from, String to) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            StoreFileMetaData fromMetaData = this.filesMetadata.get(from);
            if (fromMetaData == null) {
                throw new FileNotFoundException(from);
            }
            this.directoryService.renameFile(fromMetaData.directory(), from, to);
            StoreFileMetaData toMetaData = new StoreFileMetaData(to, fromMetaData.length(), fromMetaData.lastModified(), fromMetaData.checksum(), fromMetaData.directory());
            this.filesMetadata = MapBuilder.newMapBuilder(this.filesMetadata).remove(from).put(to, toMetaData).immutableMap();
            this.files = ((ImmutableCollection)((Object)this.filesMetadata.keySet())).toArray(new String[this.filesMetadata.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readChecksums(File[] locations) throws IOException {
        Directory[] dirs = new Directory[locations.length];
        try {
            for (int i2 = 0; i2 < locations.length; ++i2) {
                dirs[i2] = new SimpleFSDirectory(locations[i2]);
            }
            Map<String, String> map = Store.readChecksums(dirs, null);
            return map;
        }
        finally {
            for (Directory dir : dirs) {
                if (dir == null) continue;
                try {
                    dir.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> readChecksums(Directory[] dirs, Map<String, String> defaultValue) throws IOException {
        long lastFound = -1L;
        Directory lastDir = null;
        for (Directory dir : dirs) {
            for (String name2 : dir.listAll()) {
                long current2;
                if (!Store.isChecksum(name2) || (current2 = Long.parseLong(name2.substring(CHECKSUMS_PREFIX.length()))) <= lastFound) continue;
                lastFound = current2;
                lastDir = dir;
            }
        }
        if (lastFound == -1L) {
            return defaultValue;
        }
        IndexInput indexInput = lastDir.openInput(CHECKSUMS_PREFIX + lastFound);
        try {
            indexInput.readInt();
            Map<String, String> len$ = indexInput.readStringStringMap();
            return len$;
        }
        catch (Exception e) {
            Map<String, String> map = defaultValue;
            return map;
        }
        finally {
            indexInput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChecksums() throws IOException {
        String checksumName = CHECKSUMS_PREFIX + System.currentTimeMillis();
        ImmutableMap<String, StoreFileMetaData> files = this.list();
        Object object = this.mutex;
        synchronized (object) {
            HashMap<String, String> checksums = new HashMap<String, String>();
            for (StoreFileMetaData metaData : files.values()) {
                if (metaData.checksum() == null) continue;
                checksums.put(metaData.name(), metaData.checksum());
            }
            IndexOutput output = this.directory.createOutput(checksumName, true);
            output.writeInt(0);
            output.writeStringStringMap(checksums);
            output.close();
        }
        for (StoreFileMetaData metaData : files.values()) {
            if (!metaData.name().startsWith(CHECKSUMS_PREFIX) || checksumName.equals(metaData.name())) continue;
            try {
                this.directory.deleteFileChecksum(metaData.name());
            }
            catch (Exception e) {}
        }
    }

    public boolean suggestUseCompoundFile() {
        return false;
    }

    public void close() throws IOException {
        this.indexSettingsService.removeListener(this.applySettings);
        this.directory.close();
    }

    public IndexOutput createOutputRaw(String name2) throws IOException {
        return this.directory.createOutput(name2, true);
    }

    public IndexInput openInputRaw(String name2) throws IOException {
        StoreFileMetaData metaData = this.filesMetadata.get(name2);
        if (metaData == null) {
            throw new FileNotFoundException(name2);
        }
        return metaData.directory().openInput(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChecksum(String name2, String checksum) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            StoreFileMetaData metaData = this.filesMetadata.get(name2);
            metaData = new StoreFileMetaData(metaData.name(), metaData.length(), metaData.lastModified(), checksum, metaData.directory());
            this.filesMetadata = MapBuilder.newMapBuilder(this.filesMetadata).put(name2, metaData).immutableMap();
            this.writeChecksums();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChecksums(Map<String, String> checksums) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            for (Map.Entry<String, String> entry : checksums.entrySet()) {
                StoreFileMetaData metaData = this.filesMetadata.get(entry.getKey());
                metaData = new StoreFileMetaData(metaData.name(), metaData.length(), metaData.lastModified(), entry.getValue(), metaData.directory());
                this.filesMetadata = MapBuilder.newMapBuilder(this.filesMetadata).put(entry.getKey(), metaData).immutableMap();
            }
            this.writeChecksums();
        }
    }

    static /* synthetic */ String[] access$602(Store x0, String[] x1) {
        x0.files = x1;
        return x1;
    }

    class StoreIndexOutput
    extends IndexOutput {
        private final StoreFileMetaData metaData;
        private final IndexOutput out;
        private final String name;

        StoreIndexOutput(StoreFileMetaData metaData, IndexOutput delegate2, String name2) {
            this.metaData = metaData;
            this.out = delegate2;
            this.name = name2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            this.out.close();
            String checksum = null;
            IndexOutput underlying = this.out;
            if (this.out instanceof CompressedIndexOutput) {
                underlying = ((CompressedIndexOutput)this.out).underlying();
            }
            if (underlying instanceof BufferedChecksumIndexOutput) {
                checksum = Long.toString(((BufferedChecksumIndexOutput)underlying).digest().getValue(), 36);
            } else if (underlying instanceof ChecksumIndexOutput) {
                checksum = Long.toString(((ChecksumIndexOutput)underlying).digest().getValue(), 36);
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                StoreFileMetaData md = new StoreFileMetaData(this.name, this.metaData.directory().fileLength(this.name), this.metaData.directory().fileModified(this.name), checksum, this.metaData.directory());
                Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).put(this.name, md).immutableMap();
                Store.access$602(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
            }
        }

        @Override
        public void copyBytes(DataInput input, long numBytes) throws IOException {
            this.out.copyBytes(input, numBytes);
        }

        @Override
        public long getFilePointer() {
            return this.out.getFilePointer();
        }

        @Override
        public void writeByte(byte b) throws IOException {
            this.out.writeByte(b);
        }

        @Override
        public void writeBytes(byte[] b, int offset2, int length2) throws IOException {
            this.out.writeBytes(b, offset2, length2);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void seek(long pos2) throws IOException {
            this.out.seek(pos2);
        }

        @Override
        public long length() throws IOException {
            return this.out.length();
        }

        @Override
        public void setLength(long length2) throws IOException {
            this.out.setLength(length2);
        }

        public String toString() {
            return this.out.toString();
        }
    }

    class StoreDirectory
    extends Directory
    implements ForceSyncDirectory {
        private final Directory[] delegates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StoreDirectory(Directory[] delegates) throws IOException {
            this.delegates = delegates;
            Object object = Store.this.mutex;
            synchronized (object) {
                MapBuilder<String, StoreFileMetaData> builder = MapBuilder.newMapBuilder();
                Map<String, String> checksums = Store.readChecksums(delegates, new HashMap<String, String>());
                for (Directory delegate2 : delegates) {
                    for (String file2 : delegate2.listAll()) {
                        String checksum = checksums.get(file2);
                        builder.put(file2, new StoreFileMetaData(file2, delegate2.fileLength(file2), delegate2.fileModified(file2), checksum, delegate2));
                    }
                }
                Store.this.filesMetadata = builder.immutableMap();
                Store.access$602(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
            }
        }

        public Directory[] delegates() {
            return this.delegates;
        }

        @Override
        public String[] listAll() throws IOException {
            return Store.this.files;
        }

        @Override
        public boolean fileExists(String name2) throws IOException {
            return Store.this.filesMetadata.containsKey(name2);
        }

        @Override
        public long fileModified(String name2) throws IOException {
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name2);
            if (metaData == null) {
                throw new FileNotFoundException(name2);
            }
            if (metaData.lastModified() != -1L) {
                return metaData.lastModified();
            }
            return metaData.directory().fileModified(name2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void touchFile(String name2) throws IOException {
            Object object = Store.this.mutex;
            synchronized (object) {
                StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name2);
                if (metaData != null) {
                    metaData.directory().touchFile(name2);
                    metaData = new StoreFileMetaData(metaData.name(), metaData.length(), metaData.directory().fileModified(name2), metaData.checksum(), metaData.directory());
                    Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).put(name2, metaData).immutableMap();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteFileChecksum(String name2) throws IOException {
            block6: {
                StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name2);
                if (metaData != null) {
                    try {
                        metaData.directory().deleteFile(name2);
                    }
                    catch (IOException e) {
                        if (!metaData.directory().fileExists(name2)) break block6;
                        throw e;
                    }
                }
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).remove(name2).immutableMap();
                Store.access$602(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteFile(String name2) throws IOException {
            block7: {
                if (Store.isChecksum(name2)) {
                    return;
                }
                StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name2);
                if (metaData != null) {
                    try {
                        metaData.directory().deleteFile(name2);
                    }
                    catch (IOException e) {
                        if (!metaData.directory().fileExists(name2)) break block7;
                        throw e;
                    }
                }
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).remove(name2).immutableMap();
                Store.access$602(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
            }
        }

        @Override
        public long fileLength(String name2) throws IOException {
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name2);
            if (metaData == null) {
                throw new FileNotFoundException(name2);
            }
            if (metaData.length() != -1L) {
                return metaData.length();
            }
            return metaData.directory().fileLength(name2);
        }

        @Override
        public IndexOutput createOutput(String name2) throws IOException {
            return this.createOutput(name2, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexOutput createOutput(String name2, boolean raw) throws IOException {
            Directory directory = null;
            if (Store.isChecksum(name2)) {
                directory = this.delegates[0];
            } else if (this.delegates.length == 1) {
                directory = this.delegates[0];
            } else {
                long size2 = Long.MIN_VALUE;
                for (Directory delegate2 : this.delegates) {
                    if (delegate2 instanceof FSDirectory) {
                        long currentSize = ((FSDirectory)delegate2).getDirectory().getUsableSpace();
                        if (currentSize > size2) {
                            size2 = currentSize;
                            directory = delegate2;
                            continue;
                        }
                        if (currentSize != size2 || !ThreadLocalRandom.current().nextBoolean()) continue;
                        directory = delegate2;
                        continue;
                    }
                    directory = delegate2;
                }
            }
            IndexOutput out = directory.createOutput(name2);
            Object object = Store.this.mutex;
            synchronized (object) {
                boolean computeChecksum;
                StoreFileMetaData metaData = new StoreFileMetaData(name2, -1L, -1L, null, directory);
                Store.this.filesMetadata = MapBuilder.newMapBuilder(Store.this.filesMetadata).put(name2, metaData).immutableMap();
                Store.access$602(Store.this, ((ImmutableCollection)((Object)Store.this.filesMetadata.keySet())).toArray(new String[Store.this.filesMetadata.size()]));
                boolean bl = computeChecksum = !raw;
                if (computeChecksum && ("segments.gen".equals(name2) || name2.startsWith("segments"))) {
                    computeChecksum = false;
                }
                if (!raw && (Store.this.compressStored && name2.endsWith(".fdt") || Store.this.compressTv && name2.endsWith(".tvf"))) {
                    if (computeChecksum) {
                        out = new ChecksumIndexOutput(out, new Adler32());
                    }
                    out = CompressorFactory.defaultCompressor().indexOutput(out);
                } else if (computeChecksum) {
                    out = new BufferedChecksumIndexOutput(out, new Adler32());
                }
                return new StoreIndexOutput(metaData, out, name2);
            }
        }

        @Override
        public IndexInput openInput(String name2) throws IOException {
            Compressor compressor;
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name2);
            if (metaData == null) {
                throw new FileNotFoundException(name2);
            }
            IndexInput in = metaData.directory().openInput(name2);
            if ((name2.endsWith(".fdt") || name2.endsWith(".tvf")) && (compressor = CompressorFactory.compressor(in)) != null) {
                in = compressor.indexInput(in);
            }
            return in;
        }

        @Override
        public IndexInput openInput(String name2, int bufferSize) throws IOException {
            Compressor compressor;
            StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(name2);
            if (metaData == null) {
                throw new FileNotFoundException(name2);
            }
            IndexInput in = metaData.directory().openInput(name2, bufferSize);
            if ((name2.endsWith(".fdt") || name2.endsWith(".tvf")) && (compressor = CompressorFactory.compressor(in)) != null) {
                in = compressor.indexInput(in);
            }
            return in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            for (Directory delegate2 : this.delegates) {
                delegate2.close();
            }
            Object object = Store.this.mutex;
            synchronized (object) {
                Store.this.filesMetadata = ImmutableMap.of();
                Store.access$602(Store.this, Strings.EMPTY_ARRAY);
            }
        }

        @Override
        public Lock makeLock(String name2) {
            return this.delegates[0].makeLock(name2);
        }

        @Override
        public void clearLock(String name2) throws IOException {
            this.delegates[0].clearLock(name2);
        }

        @Override
        public void setLockFactory(LockFactory lockFactory) throws IOException {
            this.delegates[0].setLockFactory(lockFactory);
        }

        @Override
        public LockFactory getLockFactory() {
            return this.delegates[0].getLockFactory();
        }

        @Override
        public String getLockID() {
            return this.delegates[0].getLockID();
        }

        @Override
        public void sync(Collection<String> names2) throws IOException {
            if (Store.this.sync) {
                HashMap map = Maps.newHashMap();
                for (String string2 : names2) {
                    StoreFileMetaData metaData = (StoreFileMetaData)Store.this.filesMetadata.get(string2);
                    if (metaData == null) {
                        throw new FileNotFoundException(string2);
                    }
                    ArrayList<String> dirNames = (ArrayList<String>)map.get(metaData.directory());
                    if (dirNames == null) {
                        dirNames = new ArrayList<String>();
                        map.put(metaData.directory(), dirNames);
                    }
                    dirNames.add(string2);
                }
                for (Map.Entry entry : map.entrySet()) {
                    ((Directory)entry.getKey()).sync((Collection)entry.getValue());
                }
            }
            for (String name3 : names2) {
                if (name3.equals("segments.gen") || !name3.startsWith("segments")) continue;
                Store.this.writeChecksums();
                break;
            }
        }

        @Override
        public void sync(String name2) throws IOException {
            if (Store.this.sync) {
                this.sync(ImmutableList.of(name2));
            }
            if (!name2.equals("segments.gen") && name2.startsWith("segments")) {
                Store.this.writeChecksums();
            }
        }

        @Override
        public void forceSync(String name2) throws IOException {
            this.sync(ImmutableList.of(name2));
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            boolean compressTv;
            boolean compressStored = settings.getAsBoolean(Store.INDEX_STORE_COMPRESS_STORED, Store.this.compressStored);
            if (compressStored != Store.this.compressStored) {
                Store.this.logger.info("updating [index.store.compress.stored] from [{}] to [{}]", Store.this.compressStored, compressStored);
                Store.this.compressStored = compressStored;
            }
            if ((compressTv = settings.getAsBoolean(Store.INDEX_STORE_COMPRESS_TV, Store.this.compressTv).booleanValue()) != Store.this.compressTv) {
                Store.this.logger.info("updating [index.store.compress.tv] from [{}] to [{}]", Store.this.compressTv, compressTv);
                Store.this.compressTv = compressTv;
            }
        }
    }
}

