/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard.service;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastByteArrayOutputStream;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.IgnoreOnRecoveryEngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.get.ShardGetService;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.search.stats.ShardSearchService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.recovery.RecoveryStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalIndexShard
extends AbstractIndexShardComponent
implements IndexShard {
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexCache indexCache;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final Store store;
    private final MergeSchedulerProvider mergeScheduler;
    private final Engine engine;
    private final Translog translog;
    private final IndexAliasesService indexAliasesService;
    private final ShardIndexingService indexingService;
    private final ShardSearchService searchService;
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private long checkIndexTook = 0L;
    private volatile IndexShardState state;
    private TimeValue refreshInterval;
    private final TimeValue mergeInterval;
    private volatile ScheduledFuture refreshScheduledFuture;
    private volatile ScheduledFuture mergeScheduleFuture;
    private volatile ShardRouting shardRouting;
    private RecoveryStatus peerRecoveryStatus;
    private ApplyRefreshSettings applyRefreshSettings = new ApplyRefreshSettings();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    public static final String INDEX_REFRESH_INTERVAL = "index.refresh_interval";

    @Inject
    public InternalIndexShard(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, IndicesLifecycle indicesLifecycle, Store store, Engine engine, MergeSchedulerProvider mergeScheduler, Translog translog, ThreadPool threadPool, MapperService mapperService, IndexQueryParserService queryParserService, IndexCache indexCache, IndexAliasesService indexAliasesService, ShardIndexingService indexingService, ShardGetService getService, ShardSearchService searchService, ShardIndexWarmerService shardWarmerService) {
        super(shardId, indexSettings);
        this.indicesLifecycle = (InternalIndicesLifecycle)indicesLifecycle;
        this.indexSettingsService = indexSettingsService;
        this.store = store;
        this.engine = engine;
        this.mergeScheduler = mergeScheduler;
        this.translog = translog;
        this.threadPool = threadPool;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexCache = indexCache;
        this.indexAliasesService = indexAliasesService;
        this.indexingService = indexingService;
        this.getService = getService.setIndexShard(this);
        this.searchService = searchService;
        this.shardWarmerService = shardWarmerService;
        this.state = IndexShardState.CREATED;
        this.refreshInterval = indexSettings.getAsTime("engine.robin.refresh_interval", indexSettings.getAsTime(INDEX_REFRESH_INTERVAL, engine.defaultRefreshInterval()));
        this.mergeInterval = indexSettings.getAsTime("index.merge.async_interval", TimeValue.timeValueSeconds(1L));
        indexSettingsService.addListener(this.applyRefreshSettings);
        this.logger.debug("state: [CREATED]", new Object[0]);
        this.checkIndexOnStartup = indexSettings.get("index.shard.check_on_startup", "false");
    }

    public MergeSchedulerProvider mergeScheduler() {
        return this.mergeScheduler;
    }

    public Store store() {
        return this.store;
    }

    public Engine engine() {
        return this.engine;
    }

    public Translog translog() {
        return this.translog;
    }

    @Override
    public ShardIndexingService indexingService() {
        return this.indexingService;
    }

    @Override
    public ShardGetService getService() {
        return this.getService;
    }

    @Override
    public ShardSearchService searchService() {
        return this.searchService;
    }

    @Override
    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    public InternalIndexShard routingEntry(ShardRouting shardRouting) {
        ShardRouting currentRouting = this.shardRouting;
        if (!shardRouting.shardId().equals(this.shardId())) {
            throw new ElasticSearchIllegalArgumentException("Trying to set a routing entry with shardId [" + shardRouting.shardId() + "] on a shard with shardId [" + this.shardId() + "]");
        }
        if (currentRouting != null) {
            if (!shardRouting.primary() && currentRouting.primary()) {
                this.logger.warn("suspect illegal state: trying to move shard from primary mode to replica mode", new Object[0]);
            }
            if (currentRouting.equals(shardRouting)) {
                return this;
            }
        }
        this.shardRouting = shardRouting;
        this.indicesLifecycle.shardRoutingChanged(this, currentRouting, shardRouting);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState recovering(String reason2) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            IndexShardState returnValue = this.state;
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.RECOVERING, reason2});
            this.state = IndexShardState.RECOVERING;
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexShard relocated(String reason2) throws IndexShardNotStartedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.STARTED) {
                throw new IndexShardNotStartedException(this.shardId, this.state);
            }
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.RELOCATED, reason2});
            this.state = IndexShardState.RELOCATED;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexShard start(String reason2) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (Booleans.parseBoolean(this.checkIndexOnStartup, false)) {
                this.checkIndex(true);
            }
            this.engine.start();
            this.startScheduledTasksIfNeeded();
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.STARTED, reason2});
            this.state = IndexShardState.STARTED;
        }
        this.indicesLifecycle.afterIndexShardStarted(this);
        return this;
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    @Override
    public Engine.Create prepareCreate(SourceToParse source2) throws ElasticSearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(source2.type());
        ParsedDocument doc = docMapper.parse(source2);
        return new Engine.Create(docMapper, docMapper.uidMapper().term(doc.uid()), doc).startTime(startTime);
    }

    @Override
    public ParsedDocument create(Engine.Create create2) throws ElasticSearchException {
        this.writeAllowed();
        create2 = this.indexingService.preCreate(create2);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index {}", create2.docs());
        }
        this.engine.create(create2);
        create2.endTime(System.nanoTime());
        this.indexingService.postCreate(create2);
        return create2.parsedDoc();
    }

    @Override
    public Engine.Index prepareIndex(SourceToParse source2) throws ElasticSearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(source2.type());
        ParsedDocument doc = docMapper.parse(source2);
        return new Engine.Index(docMapper, docMapper.uidMapper().term(doc.uid()), doc).startTime(startTime);
    }

    @Override
    public ParsedDocument index(Engine.Index index2) throws ElasticSearchException {
        this.writeAllowed();
        index2 = this.indexingService.preIndex(index2);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index {}", index2.docs());
            }
            this.engine.index(index2);
            index2.endTime(System.nanoTime());
        }
        catch (RuntimeException ex) {
            this.indexingService.failedIndex(index2);
            throw ex;
        }
        this.indexingService.postIndex(index2);
        return index2.parsedDoc();
    }

    @Override
    public Engine.Delete prepareDelete(String type2, String id2, long version) throws ElasticSearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(type2);
        return new Engine.Delete(type2, id2, docMapper.uidMapper().term(type2, id2)).version(version).startTime(startTime);
    }

    @Override
    public void delete(Engine.Delete delete2) throws ElasticSearchException {
        this.writeAllowed();
        delete2 = this.indexingService.preDelete(delete2);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}]", delete2.uid().text());
            }
            this.engine.delete(delete2);
            delete2.endTime(System.nanoTime());
        }
        catch (RuntimeException ex) {
            this.indexingService.failedDelete(delete2);
            throw ex;
        }
        this.indexingService.postDelete(delete2);
    }

    @Override
    public Engine.DeleteByQuery prepareDeleteByQuery(BytesReference querySource, @Nullable String[] filteringAliases, String ... types) throws ElasticSearchException {
        long startTime = System.nanoTime();
        if (types == null) {
            types = Strings.EMPTY_ARRAY;
        }
        Query query = this.queryParserService.parse(querySource).query();
        query = this.filterQueryIfNeeded(query, types);
        Filter aliasFilter = this.indexAliasesService.aliasFilter(filteringAliases);
        Filter parentFilter = this.mapperService.hasNested() ? this.indexCache.filter().cache(NonNestedDocsFilter.INSTANCE) : null;
        return new Engine.DeleteByQuery(query, querySource, filteringAliases, aliasFilter, parentFilter, types).startTime(startTime);
    }

    @Override
    public void deleteByQuery(Engine.DeleteByQuery deleteByQuery) throws ElasticSearchException {
        this.writeAllowed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("delete_by_query [{}]", deleteByQuery.query());
        }
        deleteByQuery = this.indexingService.preDeleteByQuery(deleteByQuery);
        this.engine.delete(deleteByQuery);
        deleteByQuery.endTime(System.nanoTime());
        this.indexingService.postDeleteByQuery(deleteByQuery);
    }

    @Override
    public Engine.GetResult get(Engine.Get get2) throws ElasticSearchException {
        this.readAllowed();
        return this.engine.get(get2);
    }

    @Override
    public void refresh(Engine.Refresh refresh) throws ElasticSearchException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with {}", refresh);
        }
        long time = System.nanoTime();
        this.engine.refresh(refresh);
        this.refreshMetric.inc(System.nanoTime() - time);
    }

    @Override
    public RefreshStats refreshStats() {
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()));
    }

    @Override
    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocsStats docStats() {
        Engine.Searcher searcher = null;
        try {
            searcher = this.engine.searcher();
            DocsStats docsStats = new DocsStats(searcher.reader().numDocs(), searcher.reader().numDeletedDocs());
            return docsStats;
        }
        catch (Exception e) {
            DocsStats docsStats = new DocsStats();
            return docsStats;
        }
        finally {
            if (searcher != null) {
                searcher.release();
            }
        }
    }

    @Override
    public IndexingStats indexingStats(String ... types) {
        return this.indexingService.stats(types);
    }

    @Override
    public SearchStats searchStats(String ... groups2) {
        return this.searchService.stats(groups2);
    }

    @Override
    public GetStats getStats() {
        return this.getService.stats();
    }

    @Override
    public StoreStats storeStats() {
        try {
            return this.store.stats();
        }
        catch (IOException e) {
            return new StoreStats();
        }
    }

    @Override
    public MergeStats mergeStats() {
        return this.mergeScheduler.stats();
    }

    @Override
    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    @Override
    public void flush(Engine.Flush flush2) throws ElasticSearchException {
        this.verifyStartedOrRecovering();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("flush with {}", flush2);
        }
        long time = System.nanoTime();
        this.engine.flush(flush2);
        this.flushMetric.inc(System.nanoTime() - time);
    }

    @Override
    public void optimize(Engine.Optimize optimize) throws ElasticSearchException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("optimize with {}", optimize);
        }
        this.engine.optimize(optimize);
    }

    @Override
    public <T> T snapshot(Engine.SnapshotHandler<T> snapshotHandler) throws EngineException {
        IndexShardState state2 = this.state;
        if (state2 != IndexShardState.STARTED && state2 != IndexShardState.RELOCATED && state2 != IndexShardState.CLOSED) {
            throw new IllegalIndexShardStateException(this.shardId, state2, "snapshot is not allowed");
        }
        return this.engine.snapshot(snapshotHandler);
    }

    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        this.verifyStarted();
        this.engine.recover(recoveryHandler);
    }

    @Override
    public Engine.Searcher searcher() {
        this.readAllowed();
        return this.engine.searcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason2) {
        Object object = this.mutex;
        synchronized (object) {
            this.indexSettingsService.removeListener(this.applyRefreshSettings);
            if (this.state != IndexShardState.CLOSED) {
                if (this.refreshScheduledFuture != null) {
                    this.refreshScheduledFuture.cancel(true);
                    this.refreshScheduledFuture = null;
                }
                if (this.mergeScheduleFuture != null) {
                    this.mergeScheduleFuture.cancel(true);
                    this.mergeScheduleFuture = null;
                }
            }
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.CLOSED, reason2});
            this.state = IndexShardState.CLOSED;
        }
    }

    public long checkIndexTook() {
        return this.checkIndexTook;
    }

    public void performRecoveryPrepareForTranslog() throws ElasticSearchException {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        if (Booleans.parseBoolean(this.checkIndexOnStartup, false)) {
            this.checkIndex(true);
        }
        this.engine.enableGcDeletes(false);
        this.engine.start();
    }

    public RecoveryStatus peerRecoveryStatus() {
        return this.peerRecoveryStatus;
    }

    public void performRecoveryFinalization(boolean withFlush, RecoveryStatus peerRecoveryStatus) throws ElasticSearchException {
        this.performRecoveryFinalization(withFlush);
        this.peerRecoveryStatus = peerRecoveryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryFinalization(boolean withFlush) throws ElasticSearchException {
        if (withFlush) {
            this.engine.flush(new Engine.Flush());
        }
        this.translog.clearUnreferenced();
        this.engine.refresh(new Engine.Refresh(true));
        Object object = this.mutex;
        synchronized (object) {
            this.logger.debug("state: [{}]->[{}], reason [post recovery]", new Object[]{this.state, IndexShardState.STARTED});
            this.state = IndexShardState.STARTED;
        }
        this.startScheduledTasksIfNeeded();
        this.indicesLifecycle.afterIndexShardStarted(this);
        this.engine.enableGcDeletes(true);
    }

    public void performRecoveryOperation(Translog.Operation operation) throws ElasticSearchException {
        block11: {
            if (this.state != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId, this.state);
            }
            try {
                switch (operation.opType()) {
                    case CREATE: {
                        Translog.Create create2 = (Translog.Create)operation;
                        this.engine.create(this.prepareCreate(SourceToParse.source(create2.source()).type(create2.type()).id(create2.id()).routing(create2.routing()).parent(create2.parent()).timestamp(create2.timestamp()).ttl(create2.ttl())).version(create2.version()).origin(Engine.Operation.Origin.RECOVERY));
                        break;
                    }
                    case SAVE: {
                        Translog.Index index2 = (Translog.Index)operation;
                        this.engine.index(this.prepareIndex(SourceToParse.source(index2.source()).type(index2.type()).id(index2.id()).routing(index2.routing()).parent(index2.parent()).timestamp(index2.timestamp()).ttl(index2.ttl())).version(index2.version()).origin(Engine.Operation.Origin.RECOVERY));
                        break;
                    }
                    case DELETE: {
                        Translog.Delete delete2 = (Translog.Delete)operation;
                        Uid uid2 = Uid.createUid(delete2.uid().text());
                        this.engine.delete(new Engine.Delete(uid2.type(), uid2.id(), delete2.uid()).version(delete2.version()).origin(Engine.Operation.Origin.RECOVERY));
                        break;
                    }
                    case DELETE_BY_QUERY: {
                        Translog.DeleteByQuery deleteByQuery = (Translog.DeleteByQuery)operation;
                        this.engine.delete(this.prepareDeleteByQuery(deleteByQuery.source(), deleteByQuery.filteringAliases(), deleteByQuery.types()));
                        break;
                    }
                    default: {
                        throw new ElasticSearchIllegalStateException("No operation defined for [" + operation + "]");
                    }
                }
            }
            catch (ElasticSearchException e) {
                boolean hasIgnoreOnRecoveryException = false;
                ElasticSearchException current2 = e;
                while (true) {
                    if (current2 instanceof IgnoreOnRecoveryEngineException) {
                        hasIgnoreOnRecoveryException = true;
                        break;
                    }
                    if (!(current2.getCause() instanceof ElasticSearchException)) break;
                    current2 = (ElasticSearchException)current2.getCause();
                }
                if (hasIgnoreOnRecoveryException) break block11;
                throw e;
            }
        }
    }

    @Override
    public boolean ignoreRecoveryAttempt() {
        IndexShardState state2 = this.state();
        return state2 == IndexShardState.RECOVERING || state2 == IndexShardState.STARTED || state2 == IndexShardState.RELOCATED || state2 == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state2 = this.state;
        if (state2 != IndexShardState.STARTED && state2 != IndexShardState.RELOCATED) {
            throw new IllegalIndexShardStateException(this.shardId, state2, "Read operations only allowed when started/relocated");
        }
    }

    private void writeAllowed() throws IllegalIndexShardStateException {
        this.verifyStartedOrRecovering();
    }

    private void verifyStartedOrRecovering() throws IllegalIndexShardStateException {
        IndexShardState state2 = this.state;
        if (state2 != IndexShardState.STARTED && state2 != IndexShardState.RECOVERING) {
            throw new IllegalIndexShardStateException(this.shardId, state2, "write operation only allowed when started/recovering");
        }
    }

    private void verifyStarted() throws IllegalIndexShardStateException {
        IndexShardState state2 = this.state;
        if (state2 != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, state2);
        }
    }

    private void startScheduledTasksIfNeeded() {
        if (this.refreshInterval.millis() > 0L) {
            this.refreshScheduledFuture = this.threadPool.schedule(this.refreshInterval, "same", new EngineRefresher());
            this.logger.debug("scheduling refresher every {}", this.refreshInterval);
        } else {
            this.logger.debug("scheduled refresher disabled", new Object[0]);
        }
        if (this.mergeInterval.millis() > 0L) {
            this.mergeScheduleFuture = this.threadPool.schedule(this.mergeInterval, "same", new EngineMerger());
            this.logger.debug("scheduling optimizer / merger every {}", this.mergeInterval);
        } else {
            this.logger.debug("scheduled optimizer / merger disabled", new Object[0]);
        }
    }

    private Query filterQueryIfNeeded(Query query, String[] types) {
        Filter searchFilter = this.mapperService.searchFilter(types);
        if (searchFilter != null) {
            query = new FilteredQuery(query, this.indexCache.filter().cache(searchFilter));
        }
        return query;
    }

    private void checkIndex(boolean throwException) throws IndexShardException {
        try {
            this.checkIndexTook = 0L;
            long time = System.currentTimeMillis();
            if (!Lucene.indexExists(this.store.directory())) {
                return;
            }
            CheckIndex checkIndex = new CheckIndex(this.store.directory());
            FastByteArrayOutputStream os = new FastByteArrayOutputStream();
            PrintStream out = new PrintStream(os);
            checkIndex.setInfoStream(out);
            out.flush();
            CheckIndex.Status status2 = checkIndex.checkIndex();
            if (!status2.clean) {
                if (this.state == IndexShardState.CLOSED) {
                    return;
                }
                this.logger.warn("check index [failure]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
                if ("fix".equalsIgnoreCase(this.checkIndexOnStartup)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("fixing index, writing new segments file ...", new Object[0]);
                    }
                    checkIndex.fixIndex(status2);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("index fixed, wrote new segments file \"{}\"", status2.segmentsFileName);
                    }
                } else if (throwException) {
                    throw new IndexShardException(this.shardId, "index check failure");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("check index [success]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
            }
            this.checkIndexTook = System.currentTimeMillis() - time;
        }
        catch (Exception e) {
            this.logger.warn("failed to check index", e, new Object[0]);
        }
    }

    class EngineMerger
    implements Runnable {
        EngineMerger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!InternalIndexShard.this.engine().possibleMergeNeeded()) {
                Object object = InternalIndexShard.this.mutex;
                synchronized (object) {
                    if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                        InternalIndexShard.this.mergeScheduleFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.mergeInterval, "same", this);
                    }
                }
                return;
            }
            InternalIndexShard.this.threadPool.executor("merge").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block9: {
                        try {
                            InternalIndexShard.this.engine.maybeMerge();
                        }
                        catch (EngineClosedException e) {
                        }
                        catch (OptimizeFailedEngineException e) {
                            if (!(e.getCause() instanceof EngineClosedException || e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException || InternalIndexShard.this.state == IndexShardState.CLOSED)) {
                                InternalIndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (InternalIndexShard.this.state == IndexShardState.CLOSED) break block9;
                            InternalIndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                        }
                    }
                    Object object = InternalIndexShard.this.mutex;
                    synchronized (object) {
                        if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                            InternalIndexShard.this.mergeScheduleFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.mergeInterval, "same", EngineMerger.this);
                        }
                    }
                }
            });
        }
    }

    class EngineRefresher
    implements Runnable {
        EngineRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!InternalIndexShard.this.engine().refreshNeeded()) {
                Object object = InternalIndexShard.this.mutex;
                synchronized (object) {
                    if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                        InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.refreshInterval, "same", this);
                    }
                }
                return;
            }
            InternalIndexShard.this.threadPool.executor("refresh").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block10: {
                        try {
                            if (InternalIndexShard.this.engine.refreshNeeded()) {
                                InternalIndexShard.this.refresh(new Engine.Refresh(false));
                            }
                        }
                        catch (EngineClosedException e) {
                        }
                        catch (RefreshFailedEngineException e) {
                            if (!(e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException || InternalIndexShard.this.state == IndexShardState.CLOSED)) {
                                InternalIndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (InternalIndexShard.this.state == IndexShardState.CLOSED) break block10;
                            InternalIndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                        }
                    }
                    Object object = InternalIndexShard.this.mutex;
                    synchronized (object) {
                        if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                            InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.refreshInterval, "same", EngineRefresher.this);
                        }
                    }
                }
            });
        }
    }

    private class ApplyRefreshSettings
    implements IndexSettingsService.Listener {
        private ApplyRefreshSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            Object object = InternalIndexShard.this.mutex;
            synchronized (object) {
                if (InternalIndexShard.this.state == IndexShardState.CLOSED) {
                    return;
                }
                TimeValue refreshInterval = settings.getAsTime("engine.robin.refresh_interval", settings.getAsTime(InternalIndexShard.INDEX_REFRESH_INTERVAL, InternalIndexShard.this.refreshInterval));
                if (!refreshInterval.equals(InternalIndexShard.this.refreshInterval)) {
                    InternalIndexShard.this.logger.info("updating refresh_interval from [{}] to [{}]", InternalIndexShard.this.refreshInterval, refreshInterval);
                    if (InternalIndexShard.this.refreshScheduledFuture != null) {
                        InternalIndexShard.this.refreshScheduledFuture.cancel(false);
                        InternalIndexShard.this.refreshScheduledFuture = null;
                    }
                    InternalIndexShard.this.refreshInterval = refreshInterval;
                    if (refreshInterval.millis() > 0L) {
                        InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(refreshInterval, "same", new EngineRefresher());
                    }
                }
            }
        }
    }
}

