/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum IndexShardState {
    CREATED(0),
    RECOVERING(1),
    STARTED(2),
    RELOCATED(3),
    CLOSED(4);

    private final byte id;

    private IndexShardState(byte id2) {
        this.id = id2;
    }

    public byte id() {
        return this.id;
    }

    public static IndexShardState fromId(byte id2) throws ElasticSearchIllegalArgumentException {
        if (id2 == 0) {
            return CREATED;
        }
        if (id2 == 1) {
            return RECOVERING;
        }
        if (id2 == 2) {
            return STARTED;
        }
        if (id2 == 3) {
            return RELOCATED;
        }
        if (id2 == 4) {
            return CLOSED;
        }
        throw new ElasticSearchIllegalArgumentException("No mapping for id [" + id2 + "]");
    }
}

