/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.search.slowlog.ShardSlowLogSearchService;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.internal.SearchContext;

public class ShardSearchService
extends AbstractIndexShardComponent {
    private final ShardSlowLogSearchService slowLogSearchService;
    private final StatsHolder totalStats = new StatsHolder();
    private volatile Map<String, StatsHolder> groupsStats = ImmutableMap.of();

    @Inject
    public ShardSearchService(ShardId shardId, @IndexSettings Settings indexSettings, ShardSlowLogSearchService slowLogSearchService) {
        super(shardId, indexSettings);
        this.slowLogSearchService = slowLogSearchService;
    }

    public SearchStats stats(String ... groups2) {
        HashMap<String, SearchStats.Stats> groupsSt;
        SearchStats.Stats total2;
        block4: {
            total2 = this.totalStats.stats();
            groupsSt = null;
            if (groups2 == null || groups2.length <= 0) break block4;
            if (groups2.length == 1 && groups2[0].equals("_all")) {
                groupsSt = new HashMap(this.groupsStats.size());
                for (Map.Entry<String, StatsHolder> entry : this.groupsStats.entrySet()) {
                    groupsSt.put(entry.getKey(), entry.getValue().stats());
                }
            } else {
                groupsSt = new HashMap<String, SearchStats.Stats>(groups2.length);
                for (String group2 : groups2) {
                    StatsHolder statsHolder = this.groupsStats.get(group2);
                    if (statsHolder == null) continue;
                    groupsSt.put(group2, statsHolder.stats());
                }
            }
        }
        return new SearchStats(total2, groupsSt);
    }

    public void onPreQueryPhase(SearchContext searchContext) {
        this.totalStats.queryCurrent.inc();
        if (searchContext.groupStats() != null) {
            for (int i2 = 0; i2 < searchContext.groupStats().size(); ++i2) {
                this.groupStats((String)searchContext.groupStats().get((int)i2)).queryCurrent.inc();
            }
        }
    }

    public void onFailedQueryPhase(SearchContext searchContext) {
        this.totalStats.queryCurrent.dec();
        if (searchContext.groupStats() != null) {
            for (int i2 = 0; i2 < searchContext.groupStats().size(); ++i2) {
                this.groupStats((String)searchContext.groupStats().get((int)i2)).queryCurrent.dec();
            }
        }
    }

    public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
        this.totalStats.queryMetric.inc(tookInNanos);
        this.totalStats.queryCurrent.dec();
        if (searchContext.groupStats() != null) {
            for (int i2 = 0; i2 < searchContext.groupStats().size(); ++i2) {
                StatsHolder statsHolder = this.groupStats(searchContext.groupStats().get(i2));
                statsHolder.queryMetric.inc(tookInNanos);
                statsHolder.queryCurrent.dec();
            }
        }
        this.slowLogSearchService.onQueryPhase(searchContext, tookInNanos);
    }

    public void onPreFetchPhase(SearchContext searchContext) {
        this.totalStats.fetchCurrent.inc();
        if (searchContext.groupStats() != null) {
            for (int i2 = 0; i2 < searchContext.groupStats().size(); ++i2) {
                this.groupStats((String)searchContext.groupStats().get((int)i2)).fetchCurrent.inc();
            }
        }
    }

    public void onFailedFetchPhase(SearchContext searchContext) {
        this.totalStats.fetchCurrent.dec();
        if (searchContext.groupStats() != null) {
            for (int i2 = 0; i2 < searchContext.groupStats().size(); ++i2) {
                this.groupStats((String)searchContext.groupStats().get((int)i2)).fetchCurrent.dec();
            }
        }
    }

    public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
        this.totalStats.fetchMetric.inc(tookInNanos);
        this.totalStats.fetchCurrent.dec();
        if (searchContext.groupStats() != null) {
            for (int i2 = 0; i2 < searchContext.groupStats().size(); ++i2) {
                StatsHolder statsHolder = this.groupStats(searchContext.groupStats().get(i2));
                statsHolder.fetchMetric.inc(tookInNanos);
                statsHolder.fetchCurrent.dec();
            }
        }
        this.slowLogSearchService.onFetchPhase(searchContext, tookInNanos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.totalStats.clear();
        ShardSearchService shardSearchService = this;
        synchronized (shardSearchService) {
            if (!this.groupsStats.isEmpty()) {
                MapBuilder<String, StatsHolder> typesStatsBuilder = MapBuilder.newMapBuilder();
                for (Map.Entry<String, StatsHolder> typeStats : this.groupsStats.entrySet()) {
                    if (typeStats.getValue().totalCurrent() <= 0L) continue;
                    typeStats.getValue().clear();
                    typesStatsBuilder.put(typeStats.getKey(), typeStats.getValue());
                }
                this.groupsStats = typesStatsBuilder.immutableMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatsHolder groupStats(String group2) {
        StatsHolder stats = this.groupsStats.get(group2);
        if (stats == null) {
            ShardSearchService shardSearchService = this;
            synchronized (shardSearchService) {
                stats = this.groupsStats.get(group2);
                if (stats == null) {
                    stats = new StatsHolder();
                    this.groupsStats = MapBuilder.newMapBuilder(this.groupsStats).put(group2, stats).immutableMap();
                }
            }
        }
        return stats;
    }

    static class StatsHolder {
        public final MeanMetric queryMetric = new MeanMetric();
        public final MeanMetric fetchMetric = new MeanMetric();
        public final CounterMetric queryCurrent = new CounterMetric();
        public final CounterMetric fetchCurrent = new CounterMetric();

        StatsHolder() {
        }

        public SearchStats.Stats stats() {
            return new SearchStats.Stats(this.queryMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.queryMetric.sum()), this.queryCurrent.count(), this.fetchMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.fetchMetric.sum()), this.fetchCurrent.count());
        }

        public long totalCurrent() {
            return this.queryCurrent.count() + this.fetchCurrent.count();
        }

        public void clear() {
            this.queryMetric.clear();
            this.fetchMetric.clear();
        }
    }
}

