/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class SearchStats
implements Streamable,
ToXContent {
    private Stats totalStats;
    @Nullable
    Map<String, Stats> groupStats;

    public SearchStats() {
        this.totalStats = new Stats();
    }

    public SearchStats(Stats totalStats, @Nullable Map<String, Stats> groupStats) {
        this.totalStats = totalStats;
        this.groupStats = groupStats;
    }

    public void add(SearchStats searchStats) {
        this.add(searchStats, true);
    }

    public void add(SearchStats searchStats, boolean includeTypes) {
        if (searchStats == null) {
            return;
        }
        this.totalStats.add(searchStats.totalStats);
        if (includeTypes && searchStats.groupStats != null && !searchStats.groupStats.isEmpty()) {
            if (this.groupStats == null) {
                this.groupStats = new HashMap<String, Stats>(searchStats.groupStats.size());
            }
            for (Map.Entry<String, Stats> entry : searchStats.groupStats.entrySet()) {
                Stats stats = this.groupStats.get(entry.getKey());
                if (stats == null) {
                    this.groupStats.put(entry.getKey(), entry.getValue());
                    continue;
                }
                stats.add(entry.getValue());
            }
        }
    }

    public Stats total() {
        return this.totalStats;
    }

    @Nullable
    public Map<String, Stats> groupStats() {
        return this.groupStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject(Fields.SEARCH);
        this.totalStats.toXContent(builder, params2);
        if (this.groupStats != null && !this.groupStats.isEmpty()) {
            builder.startObject(Fields.GROUPS);
            for (Map.Entry<String, Stats> entry : this.groupStats.entrySet()) {
                builder.startObject(entry.getKey(), XContentBuilder.FieldCaseConversion.NONE);
                entry.getValue().toXContent(builder, params2);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static SearchStats readSearchStats(StreamInput in) throws IOException {
        SearchStats searchStats = new SearchStats();
        searchStats.readFrom(in);
        return searchStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.totalStats = Stats.readStats(in);
        if (in.readBoolean()) {
            int size2 = in.readVInt();
            this.groupStats = new HashMap<String, Stats>(size2);
            for (int i2 = 0; i2 < size2; ++i2) {
                this.groupStats.put(in.readUTF(), Stats.readStats(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        if (this.groupStats == null || this.groupStats.isEmpty()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.groupStats.size());
            for (Map.Entry<String, Stats> entry : this.groupStats.entrySet()) {
                out.writeUTF(entry.getKey());
                entry.getValue().writeTo(out);
            }
        }
    }

    static final class Fields {
        static final XContentBuilderString SEARCH = new XContentBuilderString("search");
        static final XContentBuilderString GROUPS = new XContentBuilderString("groups");
        static final XContentBuilderString QUERY_TOTAL = new XContentBuilderString("query_total");
        static final XContentBuilderString QUERY_TIME = new XContentBuilderString("query_time");
        static final XContentBuilderString QUERY_TIME_IN_MILLIS = new XContentBuilderString("query_time_in_millis");
        static final XContentBuilderString QUERY_CURRENT = new XContentBuilderString("query_current");
        static final XContentBuilderString FETCH_TOTAL = new XContentBuilderString("fetch_total");
        static final XContentBuilderString FETCH_TIME = new XContentBuilderString("fetch_time");
        static final XContentBuilderString FETCH_TIME_IN_MILLIS = new XContentBuilderString("fetch_time_in_millis");
        static final XContentBuilderString FETCH_CURRENT = new XContentBuilderString("fetch_current");

        Fields() {
        }
    }

    public static class Stats
    implements Streamable,
    ToXContent {
        private long queryCount;
        private long queryTimeInMillis;
        private long queryCurrent;
        private long fetchCount;
        private long fetchTimeInMillis;
        private long fetchCurrent;

        Stats() {
        }

        public Stats(long queryCount, long queryTimeInMillis, long queryCurrent, long fetchCount, long fetchTimeInMillis, long fetchCurrent) {
            this.queryCount = queryCount;
            this.queryTimeInMillis = queryTimeInMillis;
            this.queryCurrent = queryCurrent;
            this.fetchCount = fetchCount;
            this.fetchTimeInMillis = fetchTimeInMillis;
            this.fetchCurrent = fetchCurrent;
        }

        public void add(Stats stats) {
            this.queryCount += stats.queryCount;
            this.queryTimeInMillis += stats.queryTimeInMillis;
            this.queryCurrent += stats.queryCurrent;
            this.fetchCount += stats.fetchCount;
            this.fetchTimeInMillis += stats.fetchTimeInMillis;
            this.fetchCurrent += stats.fetchCurrent;
        }

        public long queryCount() {
            return this.queryCount;
        }

        public long getQueryCount() {
            return this.queryCount;
        }

        public TimeValue queryTime() {
            return new TimeValue(this.queryTimeInMillis);
        }

        public long queryTimeInMillis() {
            return this.queryTimeInMillis;
        }

        public long getQueryTimeInMillis() {
            return this.queryTimeInMillis;
        }

        public long queryCurrent() {
            return this.queryCurrent;
        }

        public long getQueryCurrent() {
            return this.queryCurrent;
        }

        public long fetchCount() {
            return this.fetchCount;
        }

        public long getFetchCount() {
            return this.fetchCount;
        }

        public TimeValue fetchTime() {
            return new TimeValue(this.fetchTimeInMillis);
        }

        public long fetchTimeInMillis() {
            return this.fetchTimeInMillis;
        }

        public long getFetchTimeInMillis() {
            return this.fetchTimeInMillis;
        }

        public long fetchCurrent() {
            return this.fetchCurrent;
        }

        public long getFetchCurrent() {
            return this.fetchCurrent;
        }

        public static Stats readStats(StreamInput in) throws IOException {
            Stats stats = new Stats();
            stats.readFrom(in);
            return stats;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.queryCount = in.readVLong();
            this.queryTimeInMillis = in.readVLong();
            this.queryCurrent = in.readVLong();
            this.fetchCount = in.readVLong();
            this.fetchTimeInMillis = in.readVLong();
            this.fetchCurrent = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.queryCount);
            out.writeVLong(this.queryTimeInMillis);
            out.writeVLong(this.queryCurrent);
            out.writeVLong(this.fetchCount);
            out.writeVLong(this.fetchTimeInMillis);
            out.writeVLong(this.fetchCurrent);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
            builder.field(Fields.QUERY_TOTAL, this.queryCount);
            builder.field(Fields.QUERY_TIME, this.queryTime().toString());
            builder.field(Fields.QUERY_TIME_IN_MILLIS, this.queryTimeInMillis);
            builder.field(Fields.QUERY_CURRENT, this.queryCurrent);
            builder.field(Fields.FETCH_TOTAL, this.fetchCount);
            builder.field(Fields.FETCH_TIME, this.fetchTime().toString());
            builder.field(Fields.FETCH_TIME_IN_MILLIS, this.fetchTimeInMillis);
            builder.field(Fields.FETCH_CURRENT, this.fetchCurrent);
            return builder;
        }
    }
}

