/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.shape;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.geo.GeoJSONShapeParser;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;

public class ShapeFetchService
extends AbstractComponent {
    private final Client client;

    @Inject
    public ShapeFetchService(Client client, Settings settings) {
        super(settings);
        this.client = client;
    }

    public Shape fetch(String id2, String type2, String index2, String shapeField) throws IOException {
        GetResponse response = this.client.get((GetRequest)new GetRequest(index2, type2, id2).preference("_local").operationThreaded(false)).actionGet();
        if (!response.exists()) {
            throw new ElasticSearchIllegalArgumentException("Shape with ID [" + id2 + "] in type [" + type2 + "] not found");
        }
        XContentParser parser = null;
        try {
            XContentParser.Token currentToken;
            parser = XContentHelper.createParser(response.sourceRef());
            while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (currentToken != XContentParser.Token.FIELD_NAME) continue;
                if (shapeField.equals(parser.currentName())) {
                    parser.nextToken();
                    Shape shape = GeoJSONShapeParser.parse(parser);
                    return shape;
                }
                parser.skipChildren();
            }
            throw new ElasticSearchIllegalStateException("Shape with name [" + id2 + "] found but missing " + shapeField + " field");
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }
}

