/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.FixedBitDocSet;
import org.elasticsearch.common.lucene.search.NoopCollector;

public class BlockJoinQuery
extends Query {
    private final Filter parentsFilter;
    private final Query childQuery;
    private Collector childCollector = NoopCollector.NOOP_COLLECTOR;
    private final Query origChildQuery;
    private final ScoreMode scoreMode;

    public BlockJoinQuery setCollector(Collector collector) {
        this.childCollector = collector;
        return this;
    }

    public BlockJoinQuery(Query childQuery, Filter parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = childQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    private BlockJoinQuery(Query origChildQuery, Query childQuery, Filter parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = origChildQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new BlockJoinWeight(this, this.childQuery.createWeight(searcher), this.parentsFilter, this.scoreMode, this.childCollector);
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.childQuery.extractTerms(terms);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query childRewrite = this.childQuery.rewrite(reader);
        if (childRewrite != this.childQuery) {
            BlockJoinQuery rewritten = new BlockJoinQuery(this.childQuery, childRewrite, this.parentsFilter, this.scoreMode).setCollector(this.childCollector);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    @Override
    public String toString(String field2) {
        return "BlockJoinQuery (" + this.childQuery.toString() + ")";
    }

    @Override
    public boolean equals(Object _other) {
        if (_other instanceof BlockJoinQuery) {
            BlockJoinQuery other = (BlockJoinQuery)_other;
            return this.origChildQuery.equals(other.origChildQuery) && this.parentsFilter.equals(other.parentsFilter) && this.scoreMode == other.scoreMode;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash2 = 1;
        hash2 = 31 * hash2 + this.origChildQuery.hashCode();
        hash2 = 31 * hash2 + this.scoreMode.hashCode();
        hash2 = 31 * hash2 + this.parentsFilter.hashCode();
        return hash2;
    }

    @Override
    public Object clone() {
        return new BlockJoinQuery((Query)this.origChildQuery.clone(), this.parentsFilter, this.scoreMode).setCollector(this.childCollector);
    }

    static class BlockJoinScorer
    extends Scorer {
        private final Scorer childScorer;
        private final FixedBitSet parentBits;
        private final ScoreMode scoreMode;
        private final Collector childCollector;
        private int prevParentDoc;
        private int parentDoc = -1;
        private float parentScore;
        private int nextChildDoc;
        private int[] pendingChildDocs = new int[5];
        private float[] pendingChildScores;
        private int childDocUpto;

        public BlockJoinScorer(Weight weight, Scorer childScorer, FixedBitSet parentBits, int firstChildDoc, ScoreMode scoreMode, Collector childCollector) {
            super(weight);
            this.parentBits = parentBits;
            this.childScorer = childScorer;
            this.scoreMode = scoreMode;
            this.childCollector = childCollector;
            if (scoreMode != ScoreMode.None) {
                this.pendingChildScores = new float[5];
            }
            this.nextChildDoc = firstChildDoc;
        }

        @Override
        public void visitSubScorers(Query parent, BooleanClause.Occur relationship, Scorer.ScorerVisitor<Query, Query, Scorer> visitor) {
            super.visitSubScorers(parent, relationship, visitor);
            this.childScorer.visitScorers(visitor);
        }

        int getChildCount() {
            return this.childDocUpto;
        }

        int[] swapChildDocs(int[] other) {
            int[] ret = this.pendingChildDocs;
            this.pendingChildDocs = other == null ? new int[5] : other;
            return ret;
        }

        float[] swapChildScores(float[] other) {
            if (this.scoreMode == ScoreMode.None) {
                throw new IllegalStateException("ScoreMode is None");
            }
            float[] ret = this.pendingChildScores;
            this.pendingChildScores = other == null ? new float[5] : other;
            return ret;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.nextChildDoc == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.parentDoc = this.parentBits.nextSetBit(this.nextChildDoc);
            assert (this.parentDoc != -1);
            float totalScore = 0.0f;
            float maxScore = Float.NEGATIVE_INFINITY;
            this.childDocUpto = 0;
            do {
                if (this.pendingChildDocs.length == this.childDocUpto) {
                    this.pendingChildDocs = ArrayUtil.grow(this.pendingChildDocs);
                    if (this.scoreMode != ScoreMode.None) {
                        this.pendingChildScores = ArrayUtil.grow(this.pendingChildScores);
                    }
                }
                this.pendingChildDocs[this.childDocUpto] = this.nextChildDoc;
                if (this.scoreMode != ScoreMode.None) {
                    float childScore;
                    this.pendingChildScores[this.childDocUpto] = childScore = this.childScorer.score();
                    maxScore = Math.max(childScore, maxScore);
                    totalScore += childScore;
                }
                this.childCollector.collect(this.nextChildDoc);
                ++this.childDocUpto;
                this.nextChildDoc = this.childScorer.nextDoc();
            } while (this.nextChildDoc < this.parentDoc);
            assert (this.nextChildDoc != this.parentDoc);
            switch (this.scoreMode) {
                case Avg: {
                    this.parentScore = totalScore / (float)this.childDocUpto;
                    break;
                }
                case Max: {
                    this.parentScore = maxScore;
                    break;
                }
                case Total: {
                    this.parentScore = totalScore;
                    break;
                }
            }
            return this.parentDoc;
        }

        @Override
        public int docID() {
            return this.parentDoc;
        }

        @Override
        public float score() throws IOException {
            return this.parentScore;
        }

        @Override
        public int advance(int parentTarget) throws IOException {
            if (parentTarget == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (parentTarget == 0) {
                return this.nextDoc();
            }
            this.prevParentDoc = this.parentBits.prevSetBit(parentTarget - 1);
            assert (this.prevParentDoc >= this.parentDoc);
            if (this.prevParentDoc > this.nextChildDoc) {
                this.nextChildDoc = this.childScorer.advance(this.prevParentDoc);
            }
            assert (this.nextChildDoc != this.prevParentDoc);
            int nd = this.nextDoc();
            return nd;
        }

        public Explanation explain() throws IOException {
            int start2 = this.prevParentDoc + 1;
            int end2 = this.parentDoc - 1;
            ComplexExplanation explanation = new ComplexExplanation(true, this.score(), String.format(Locale.ROOT, "Score based on score mode %s and child doc range from %d to %d", new Object[]{this.scoreMode, start2, end2}));
            for (int i2 = 0; i2 < this.childDocUpto; ++i2) {
                int childDoc = this.pendingChildDocs[i2];
                float childScore = this.pendingChildScores[i2];
                explanation.addDetail(new Explanation(childScore, String.format(Locale.ROOT, "Child[%d]", childDoc)));
            }
            return explanation;
        }
    }

    private static class BlockJoinWeight
    extends Weight {
        private final Query joinQuery;
        private final Weight childWeight;
        private final Filter parentsFilter;
        private final ScoreMode scoreMode;
        private final Collector childCollector;

        public BlockJoinWeight(Query joinQuery, Weight childWeight, Filter parentsFilter, ScoreMode scoreMode, Collector childCollector) {
            this.joinQuery = joinQuery;
            this.childWeight = childWeight;
            this.parentsFilter = parentsFilter;
            this.scoreMode = scoreMode;
            this.childCollector = childCollector;
        }

        @Override
        public Query getQuery() {
            return this.joinQuery;
        }

        @Override
        public float getValue() {
            return this.childWeight.getValue();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            return this.childWeight.sumOfSquaredWeights() * this.joinQuery.getBoost() * this.joinQuery.getBoost();
        }

        @Override
        public void normalize(float norm) {
            this.childWeight.normalize(norm * this.joinQuery.getBoost());
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer childScorer = this.childWeight.scorer(reader, true, false);
            if (childScorer == null) {
                return null;
            }
            int firstChildDoc = childScorer.nextDoc();
            if (firstChildDoc == Integer.MAX_VALUE) {
                return null;
            }
            DocIdSet parents = this.parentsFilter.getDocIdSet(reader);
            if (parents == null) {
                return null;
            }
            if (parents instanceof FixedBitDocSet) {
                parents = ((FixedBitDocSet)parents).set();
            }
            if (!(parents instanceof FixedBitSet)) {
                throw new IllegalStateException("parentFilter must return OpenBitSet; got " + parents);
            }
            if (this.childCollector != null) {
                this.childCollector.setNextReader(reader, 0);
                this.childCollector.setScorer(childScorer);
            }
            return new BlockJoinScorer(this, childScorer, (FixedBitSet)parents, firstChildDoc, this.scoreMode, this.childCollector);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            BlockJoinScorer scorer = (BlockJoinScorer)this.scorer(reader, true, false);
            if (scorer != null && scorer.advance(doc) == doc) {
                return scorer.explain();
            }
            return new ComplexExplanation(false, 0.0f, "Not a match");
        }

        @Override
        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }

    public static enum ScoreMode {
        None,
        Avg,
        Max,
        Total;

    }
}

