/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import org.elasticsearch.index.search.geo.Point;

public class GeoUtils {
    public static double normalizeLon(double lon) {
        return GeoUtils.centeredModulus(lon, 360.0);
    }

    public static double normalizeLat(double lat) {
        if ((lat = GeoUtils.centeredModulus(lat, 360.0)) < -90.0) {
            lat = -180.0 - lat;
        } else if (lat > 90.0) {
            lat = 180.0 - lat;
        }
        return lat;
    }

    public static void normalizePoint(Point point) {
        GeoUtils.normalizePoint(point, true, true);
    }

    public static void normalizePoint(Point point, boolean normLat, boolean normLon) {
        if (normLat) {
            point.lat = GeoUtils.centeredModulus(point.lat, 360.0);
            boolean shift2 = true;
            if (point.lat < -90.0) {
                point.lat = -180.0 - point.lat;
            } else if (point.lat > 90.0) {
                point.lat = 180.0 - point.lat;
            } else {
                shift2 = false;
            }
            if (shift2) {
                point.lon = normLon ? (point.lon += 180.0) : point.lon + (GeoUtils.normalizeLon(point.lon) > 0.0 ? -180.0 : 180.0);
            }
        }
        if (normLon) {
            point.lon = GeoUtils.centeredModulus(point.lon, 360.0);
        }
    }

    private static double centeredModulus(double dividend, double divisor) {
        double rtn = dividend % divisor;
        if (rtn <= 0.0) {
            rtn += divisor;
        }
        if (rtn > divisor / 2.0) {
            rtn -= divisor;
        }
        return rtn;
    }
}

