/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.lucene.search.NoopCollector;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.search.internal.ScopePhase;
import org.elasticsearch.search.internal.SearchContext;

public class ParentQuery
extends Query
implements ScopePhase.CollectorPhase {
    private final SearchContext searchContext;
    private final Query parentQuery;
    private final String parentType;
    private final Filter childrenFilter;
    private final List<String> childTypes;
    private final String scope;
    private TObjectFloatHashMap<HashedBytesArray> uidToScore;

    public ParentQuery(SearchContext searchContext, Query parentQuery, String parentType, List<String> childTypes, Filter childrenFilter, String scope) {
        this.searchContext = searchContext;
        this.parentQuery = parentQuery;
        this.parentType = parentType;
        this.childTypes = childTypes;
        this.childrenFilter = childrenFilter;
        this.scope = scope;
    }

    private ParentQuery(ParentQuery unwritten, Query rewrittenParentQuery) {
        this.searchContext = unwritten.searchContext;
        this.parentQuery = rewrittenParentQuery;
        this.parentType = unwritten.parentType;
        this.childrenFilter = unwritten.childrenFilter;
        this.childTypes = unwritten.childTypes;
        this.scope = unwritten.scope;
        this.uidToScore = unwritten.uidToScore;
    }

    @Override
    public boolean requiresProcessing() {
        return this.uidToScore == null;
    }

    @Override
    public Collector collector() {
        this.uidToScore = CacheRecycler.popObjectFloatMap();
        return new ParentUidCollector(this.uidToScore, this.searchContext, this.parentType);
    }

    @Override
    public void processCollector(Collector collector) {
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public void clear() {
        if (this.uidToScore != null) {
            CacheRecycler.pushObjectFloatMap(this.uidToScore);
        }
        this.uidToScore = null;
    }

    @Override
    public Query query() {
        return this.parentQuery;
    }

    @Override
    public String toString(String field2) {
        StringBuilder sb = new StringBuilder();
        sb.append("ParentQuery[").append(this.parentType).append("/").append(this.childTypes).append("](").append(this.parentQuery.toString(field2)).append(')').append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenChildQuery = this.parentQuery.rewrite(reader);
        if (rewrittenChildQuery == this.parentQuery) {
            return this;
        }
        ParentQuery rewrite = new ParentQuery(this, rewrittenChildQuery);
        int index2 = this.searchContext.scopePhases().indexOf(this);
        this.searchContext.scopePhases().set(index2, rewrite);
        return rewrite;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.parentQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        if (this.uidToScore == null) {
            throw new ElasticSearchIllegalStateException("has_parent query hasn't executed properly");
        }
        return new ChildWeight(this.parentQuery.createWeight(searcher));
    }

    static class ChildScorer
    extends Scorer {
        final TObjectFloatHashMap<HashedBytesArray> uidToScore;
        final DocIdSetIterator childrenIterator;
        final IdReaderTypeCache typeCache;
        int currentChildDoc = -1;
        float currentScore;

        ChildScorer(Weight weight, TObjectFloatHashMap<HashedBytesArray> uidToScore, DocIdSetIterator childrenIterator, IdReaderTypeCache typeCache) {
            super(weight);
            this.uidToScore = uidToScore;
            this.childrenIterator = childrenIterator;
            this.typeCache = typeCache;
        }

        @Override
        public float score() throws IOException {
            return this.currentScore;
        }

        @Override
        public float freq() throws IOException {
            return 1.0f;
        }

        @Override
        public int docID() {
            return this.currentChildDoc;
        }

        @Override
        public int nextDoc() throws IOException {
            while (true) {
                this.currentChildDoc = this.childrenIterator.nextDoc();
                if (this.currentChildDoc == Integer.MAX_VALUE) {
                    return this.currentChildDoc;
                }
                HashedBytesArray uid2 = this.typeCache.parentIdByDoc(this.currentChildDoc);
                if (uid2 == null) continue;
                this.currentScore = this.uidToScore.get(uid2);
                if (Float.compare(this.currentScore, 0.0f) != 0) break;
            }
            return this.currentChildDoc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.currentChildDoc = this.childrenIterator.advance(target);
            if (this.currentChildDoc == Integer.MAX_VALUE) {
                return this.currentChildDoc;
            }
            HashedBytesArray uid2 = this.typeCache.idByDoc(this.currentChildDoc);
            if (uid2 == null) {
                return this.nextDoc();
            }
            this.currentScore = this.uidToScore.get(uid2);
            if (Float.compare(this.currentScore, 0.0f) == 0) {
                return this.nextDoc();
            }
            return this.currentChildDoc;
        }
    }

    class ChildWeight
    extends Weight {
        private final Weight parentWeight;

        ChildWeight(Weight parentWeight) {
            this.parentWeight = parentWeight;
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation(ParentQuery.this.getBoost(), "not implemented yet...");
        }

        @Override
        public Query getQuery() {
            return ParentQuery.this;
        }

        @Override
        public float getValue() {
            return ParentQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float sum2 = this.parentWeight.sumOfSquaredWeights();
            return sum2 *= ParentQuery.this.getBoost() * ParentQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm) {
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            DocIdSet childrenDocSet = ParentQuery.this.childrenFilter.getDocIdSet(reader);
            if (childrenDocSet == null || childrenDocSet == DocIdSet.EMPTY_DOCIDSET) {
                return null;
            }
            IdReaderTypeCache idTypeCache = ParentQuery.this.searchContext.idCache().reader(reader).type(ParentQuery.this.parentType);
            return new ChildScorer(this, ParentQuery.this.uidToScore, childrenDocSet.iterator(), idTypeCache);
        }
    }

    static class ParentUidCollector
    extends NoopCollector {
        final TObjectFloatHashMap<HashedBytesArray> uidToScore;
        final SearchContext searchContext;
        final String parentType;
        Scorer scorer;
        IdReaderTypeCache typeCache;

        ParentUidCollector(TObjectFloatHashMap<HashedBytesArray> uidToScore, SearchContext searchContext, String parentType) {
            this.uidToScore = uidToScore;
            this.searchContext = searchContext;
            this.parentType = parentType;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.typeCache == null) {
                return;
            }
            HashedBytesArray parentUid = this.typeCache.idByDoc(doc);
            this.uidToScore.put(parentUid, this.scorer.score());
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.typeCache = this.searchContext.idCache().reader(reader).type(this.parentType);
        }
    }
}

