/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanTermQueryBuilder
extends BaseQueryBuilder
implements SpanQueryBuilder,
BoostableQueryBuilder<SpanTermQueryBuilder> {
    private final String name;
    private final Object value;
    private float boost = -1.0f;

    public SpanTermQueryBuilder(String name2, String value2) {
        this(name2, (Object)value2);
    }

    public SpanTermQueryBuilder(String name2, int value2) {
        this(name2, (Object)value2);
    }

    public SpanTermQueryBuilder(String name2, long value2) {
        this(name2, (Object)value2);
    }

    public SpanTermQueryBuilder(String name2, float value2) {
        this(name2, Float.valueOf(value2));
    }

    public SpanTermQueryBuilder(String name2, double value2) {
        this(name2, (Object)value2);
    }

    private SpanTermQueryBuilder(String name2, Object value2) {
        this.name = name2;
        this.value = value2;
    }

    @Override
    public SpanTermQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("span_term");
        if (this.boost == -1.0f) {
            builder.field(this.name, this.value);
        } else {
            builder.startObject(this.name);
            builder.field("value", this.value);
            builder.field("boost", this.boost);
            builder.endObject();
        }
        builder.endObject();
    }
}

