/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class RangeQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<RangeQueryBuilder> {
    private final String name;
    private Object from;
    private Object to;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private float boost = -1.0f;

    public RangeQueryBuilder(String name2) {
        this.name = name2;
    }

    public RangeQueryBuilder from(Object from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder from(String from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder from(int from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder from(long from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder from(float from) {
        this.from = Float.valueOf(from);
        return this;
    }

    public RangeQueryBuilder from(double from) {
        this.from = from;
        return this;
    }

    public RangeQueryBuilder gt(String from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(Object from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(int from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(long from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(float from) {
        this.from = Float.valueOf(from);
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gt(double from) {
        this.from = from;
        this.includeLower = false;
        return this;
    }

    public RangeQueryBuilder gte(String from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(Object from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(int from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(long from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(float from) {
        this.from = Float.valueOf(from);
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder gte(double from) {
        this.from = from;
        this.includeLower = true;
        return this;
    }

    public RangeQueryBuilder to(Object to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder to(String to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder to(int to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder to(long to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder to(float to) {
        this.to = Float.valueOf(to);
        return this;
    }

    public RangeQueryBuilder to(double to) {
        this.to = to;
        return this;
    }

    public RangeQueryBuilder lt(String to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(Object to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(int to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(long to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(float to) {
        this.to = Float.valueOf(to);
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lt(double to) {
        this.to = to;
        this.includeUpper = false;
        return this;
    }

    public RangeQueryBuilder lte(String to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(Object to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(int to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(long to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(float to) {
        this.to = Float.valueOf(to);
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder lte(double to) {
        this.to = to;
        this.includeUpper = true;
        return this;
    }

    public RangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public RangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    @Override
    public RangeQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("range");
        builder.startObject(this.name);
        builder.field("from", this.from);
        builder.field("to", this.to);
        builder.field("include_lower", this.includeLower);
        builder.field("include_upper", this.includeUpper);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
        builder.endObject();
    }
}

