/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.search.MatchQuery;
import org.elasticsearch.index.search.MultiMatchQuery;

public class MultiMatchQueryParser
implements QueryParser {
    public static final String NAME = "multi_match";

    @Inject
    public MultiMatchQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "multiMatch"};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String text = null;
        float boost = 1.0f;
        MatchQuery.Type type2 = MatchQuery.Type.BOOLEAN;
        MultiMatchQuery multiMatchQuery = new MultiMatchQuery(parseContext);
        String minimumShouldMatch = null;
        HashMap<String, Float> fieldNameWithBoosts = Maps.newHashMap();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("fields".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        String fField = null;
                        Float fBoost = null;
                        char[] fieldText = parser.textCharacters();
                        int end2 = parser.textOffset() + parser.textLength();
                        for (int i2 = parser.textOffset(); i2 < end2; ++i2) {
                            if (fieldText[i2] != '^') continue;
                            int relativeLocation = i2 - parser.textOffset();
                            fField = new String(fieldText, parser.textOffset(), relativeLocation);
                            fBoost = Float.valueOf(Float.parseFloat(new String(fieldText, i2 + 1, parser.textLength() - relativeLocation - 1)));
                            break;
                        }
                        if (fField == null) {
                            fField = parser.text();
                        }
                        if (Regex.isSimpleMatchPattern(fField)) {
                            for (String field2 : parseContext.mapperService().simpleMatchToIndexNames(fField)) {
                                fieldNameWithBoosts.put(field2, fBoost);
                            }
                            continue;
                        }
                        fieldNameWithBoosts.put(fField, fBoost);
                    }
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[query_string] query does not support [" + currentFieldName + "]");
            }
            if (!token.isValue()) continue;
            if ("query".equals(currentFieldName)) {
                text = parser.text();
                continue;
            }
            if ("type".equals(currentFieldName)) {
                String tStr = parser.text();
                if ("boolean".equals(tStr)) {
                    type2 = MatchQuery.Type.BOOLEAN;
                    continue;
                }
                if ("phrase".equals(tStr)) {
                    type2 = MatchQuery.Type.PHRASE;
                    continue;
                }
                if (!"phrase_prefix".equals(tStr) && !"phrasePrefix".equals(currentFieldName)) continue;
                type2 = MatchQuery.Type.PHRASE_PREFIX;
                continue;
            }
            if ("analyzer".equals(currentFieldName)) {
                String analyzer = parser.text();
                if (parseContext.analysisService().analyzer(analyzer) == null) {
                    throw new QueryParsingException(parseContext.index(), "[match] analyzer [" + parser.text() + "] not found");
                }
                multiMatchQuery.setAnalyzer(analyzer);
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("slop".equals(currentFieldName) || "phrase_slop".equals(currentFieldName) || "phraseSlop".equals(currentFieldName)) {
                multiMatchQuery.setPhraseSlop(parser.intValue());
                continue;
            }
            if ("fuzziness".equals(currentFieldName)) {
                multiMatchQuery.setFuzziness(parser.textOrNull());
                continue;
            }
            if ("prefix_length".equals(currentFieldName) || "prefixLength".equals(currentFieldName)) {
                multiMatchQuery.setFuzzyPrefixLength(parser.intValue());
                continue;
            }
            if ("max_expansions".equals(currentFieldName) || "maxExpansions".equals(currentFieldName)) {
                multiMatchQuery.setMaxExpansions(parser.intValue());
                continue;
            }
            if ("operator".equals(currentFieldName)) {
                String op = parser.text();
                if ("or".equalsIgnoreCase(op)) {
                    multiMatchQuery.setOccur(BooleanClause.Occur.SHOULD);
                    continue;
                }
                if ("and".equalsIgnoreCase(op)) {
                    multiMatchQuery.setOccur(BooleanClause.Occur.MUST);
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "text query requires operator to be either 'and' or 'or', not [" + op + "]");
            }
            if ("minimum_should_match".equals(currentFieldName) || "minimumShouldMatch".equals(currentFieldName)) {
                minimumShouldMatch = parser.textOrNull();
                continue;
            }
            if ("rewrite".equals(currentFieldName)) {
                multiMatchQuery.setRewriteMethod(QueryParsers.parseRewriteMethod(parser.textOrNull(), null));
                continue;
            }
            if ("fuzzy_rewrite".equals(currentFieldName) || "fuzzyRewrite".equals(currentFieldName)) {
                multiMatchQuery.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod(parser.textOrNull(), null));
                continue;
            }
            if ("use_dis_max".equals(currentFieldName) || "useDisMax".equals(currentFieldName)) {
                multiMatchQuery.setUseDisMax(parser.booleanValue());
                continue;
            }
            if ("tie_breaker".equals(currentFieldName) || "tieBreaker".equals(currentFieldName)) {
                multiMatchQuery.setTieBreaker(parser.floatValue());
                continue;
            }
            if ("lenient".equals(currentFieldName)) {
                multiMatchQuery.setLenient(parser.booleanValue());
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[match] query does not support [" + currentFieldName + "]");
        }
        if (text == null) {
            throw new QueryParsingException(parseContext.index(), "No text specified for match_all query");
        }
        if (fieldNameWithBoosts.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "No fields specified for match_all query");
        }
        Query query = multiMatchQuery.parse(type2, fieldNameWithBoosts, text);
        if (query == null) {
            return null;
        }
        if (query instanceof BooleanQuery) {
            Queries.applyMinimumShouldMatch((BooleanQuery)query, minimumShouldMatch);
        }
        query.setBoost(boost);
        return query;
    }
}

