/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class IdsQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<IdsQueryBuilder> {
    private final List<String> types;
    private List<String> values = new ArrayList<String>();
    private float boost = -1.0f;

    public IdsQueryBuilder(String ... types) {
        this.types = types == null ? null : Arrays.asList(types);
    }

    public IdsQueryBuilder addIds(String ... ids) {
        this.values.addAll(Arrays.asList(ids));
        return this;
    }

    public IdsQueryBuilder ids(String ... ids) {
        return this.addIds(ids);
    }

    @Override
    public IdsQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("ids");
        if (this.types != null) {
            if (this.types.size() == 1) {
                builder.field("type", this.types.get(0));
            } else {
                builder.startArray("types");
                for (String type2 : this.types) {
                    builder.value((Object)type2);
                }
                builder.endArray();
            }
        }
        builder.startArray("values");
        for (String value2 : this.values) {
            builder.value((Object)value2);
        }
        builder.endArray();
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

