/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class HasParentFilterBuilder
extends BaseFilterBuilder {
    private final QueryBuilder queryBuilder;
    private final FilterBuilder filterBuilder;
    private final String parentType;
    private String scope;
    private String filterName;
    private String executionType;

    public HasParentFilterBuilder(String parentType, QueryBuilder parentQuery) {
        this.parentType = parentType;
        this.queryBuilder = parentQuery;
        this.filterBuilder = null;
    }

    public HasParentFilterBuilder(String parentType, FilterBuilder parentFilter) {
        this.parentType = parentType;
        this.queryBuilder = null;
        this.filterBuilder = parentFilter;
    }

    public HasParentFilterBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    public HasParentFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public HasParentFilterBuilder executionType(String executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("has_parent");
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params2);
        } else if (this.filterBuilder != null) {
            builder.field("filter");
            this.filterBuilder.toXContent(builder, params2);
        }
        builder.field("parent_type", this.parentType);
        if (this.scope != null) {
            builder.field("_scope", this.scope);
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.executionType != null) {
            builder.field("execution_type", this.executionType);
        }
        builder.endObject();
    }
}

