/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class HasChildFilterBuilder
extends BaseFilterBuilder {
    private final FilterBuilder filterBuilder;
    private final QueryBuilder queryBuilder;
    private String childType;
    private String scope;
    private String filterName;
    private String executionType;

    public HasChildFilterBuilder(String type2, QueryBuilder queryBuilder) {
        this.childType = type2;
        this.queryBuilder = queryBuilder;
        this.filterBuilder = null;
    }

    public HasChildFilterBuilder(String type2, FilterBuilder filterBuilder) {
        this.childType = type2;
        this.queryBuilder = null;
        this.filterBuilder = filterBuilder;
    }

    public HasChildFilterBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    public HasChildFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public HasChildFilterBuilder executionType(String executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("has_child");
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params2);
        } else if (this.filterBuilder != null) {
            builder.field("filter");
            this.filterBuilder.toXContent(builder, params2);
        }
        builder.field("child_type", this.childType);
        if (this.scope != null) {
            builder.field("_scope", this.scope);
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.executionType != null) {
            builder.field("execution_type", this.executionType);
        }
        builder.endObject();
    }
}

