/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoJSONShapeParser;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoShapeFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.shape.ShapeFetchService;

public class GeoShapeQueryParser
implements QueryParser {
    public static final String NAME = "geo_shape";
    private ShapeFetchService fetchService;

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        ShapeRelation shapeRelation = null;
        Shape shape = null;
        String id2 = null;
        String type2 = null;
        String index2 = "shapes";
        String shapeFieldName = "shape";
        String currentFieldName = null;
        float boost = 1.0f;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if ("shape".equals(currentFieldName)) {
                        shape = GeoJSONShapeParser.parse(parser);
                        continue;
                    }
                    if ("relation".equals(currentFieldName)) {
                        shapeRelation = ShapeRelation.getRelationByName(parser.text());
                        if (shapeRelation != null) continue;
                        throw new QueryParsingException(parseContext.index(), "Unknown shape operation [" + parser.text() + " ]");
                    }
                    if (!"indexed_shape".equals(currentFieldName) && !"indexedShape".equals(currentFieldName)) continue;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (!token.isValue()) continue;
                        if ("id".equals(currentFieldName)) {
                            id2 = parser.text();
                            continue;
                        }
                        if ("type".equals(currentFieldName)) {
                            type2 = parser.text();
                            continue;
                        }
                        if ("index".equals(currentFieldName)) {
                            index2 = parser.text();
                            continue;
                        }
                        if (!"shape_field_name".equals(currentFieldName)) continue;
                        shapeFieldName = parser.text();
                    }
                    if (id2 == null) {
                        throw new QueryParsingException(parseContext.index(), "ID for indexed shape not provided");
                    }
                    if (type2 == null) {
                        throw new QueryParsingException(parseContext.index(), "Type for indexed shape not provided");
                    }
                    shape = this.fetchService.fetch(id2, type2, index2, shapeFieldName);
                }
                continue;
            }
            if (!token.isValue() || !"boost".equals(currentFieldName)) continue;
            boost = parser.floatValue();
        }
        if (shape == null) {
            throw new QueryParsingException(parseContext.index(), "No Shape defined");
        }
        if (shapeRelation == null) {
            throw new QueryParsingException(parseContext.index(), "No Shape Relation defined");
        }
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers == null || !smartNameFieldMappers.hasMapper()) {
            throw new QueryParsingException(parseContext.index(), "Failed to find geo_shape field [" + fieldName + "]");
        }
        FieldMapper fieldMapper = smartNameFieldMappers.mapper();
        if (!(fieldMapper instanceof GeoShapeFieldMapper)) {
            throw new QueryParsingException(parseContext.index(), "Field [" + fieldName + "] is not a geo_shape");
        }
        GeoShapeFieldMapper shapeFieldMapper = (GeoShapeFieldMapper)fieldMapper;
        Query query = shapeFieldMapper.spatialStrategy().createQuery(shape, shapeRelation);
        query.setBoost(boost);
        return query;
    }

    @Inject(optional=true)
    public void setFetchService(@Nullable ShapeFetchService fetchService) {
        this.fetchService = fetchService;
    }

    public static class DEFAULTS {
        public static final String INDEX_NAME = "shapes";
        public static final String SHAPE_FIELD_NAME = "shape";
    }
}

