/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilderException;

public class FuzzyLikeThisQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<FuzzyLikeThisQueryBuilder> {
    private final String[] fields;
    private Float boost;
    private String likeText = null;
    private Float minSimilarity;
    private Integer prefixLength;
    private Integer maxQueryTerms;
    private Boolean ignoreTF;
    private String analyzer;

    public FuzzyLikeThisQueryBuilder() {
        this.fields = null;
    }

    public FuzzyLikeThisQueryBuilder(String ... fields2) {
        this.fields = fields2;
    }

    public FuzzyLikeThisQueryBuilder likeText(String likeText) {
        this.likeText = likeText;
        return this;
    }

    public FuzzyLikeThisQueryBuilder minSimilarity(float minSimilarity) {
        this.minSimilarity = Float.valueOf(minSimilarity);
        return this;
    }

    public FuzzyLikeThisQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public FuzzyLikeThisQueryBuilder maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public FuzzyLikeThisQueryBuilder ignoreTF(boolean ignoreTF) {
        this.ignoreTF = ignoreTF;
        return this;
    }

    public FuzzyLikeThisQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public FuzzyLikeThisQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("flt");
        if (this.fields != null) {
            builder.startArray("fields");
            for (String field2 : this.fields) {
                builder.value(field2);
            }
            builder.endArray();
        }
        if (this.likeText == null) {
            throw new QueryBuilderException("fuzzyLikeThis requires 'likeText' to be provided");
        }
        builder.field("like_text", this.likeText);
        if (this.maxQueryTerms != null) {
            builder.field("max_query_terms", this.maxQueryTerms);
        }
        if (this.minSimilarity != null) {
            builder.field("min_similarity", this.minSimilarity);
        }
        if (this.prefixLength != null) {
            builder.field("prefix_length", this.prefixLength);
        }
        if (this.ignoreTF != null) {
            builder.field("ignore_tf", (Object)this.ignoreTF);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        builder.endObject();
    }
}

