/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.trove.list.array.TFloatArrayList;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class CustomFiltersScoreQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<CustomFiltersScoreQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private String lang;
    private float boost = -1.0f;
    private Float maxBoost;
    private Map<String, Object> params = null;
    private String scoreMode;
    private ArrayList<FilterBuilder> filters = new ArrayList();
    private ArrayList<String> scripts = new ArrayList();
    private TFloatArrayList boosts = new TFloatArrayList();

    public CustomFiltersScoreQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public CustomFiltersScoreQueryBuilder add(FilterBuilder filter, String script) {
        this.filters.add(filter);
        this.scripts.add(script);
        this.boosts.add(-1.0f);
        return this;
    }

    public CustomFiltersScoreQueryBuilder add(FilterBuilder filter, float boost) {
        this.filters.add(filter);
        this.scripts.add(null);
        this.boosts.add(boost);
        return this;
    }

    public CustomFiltersScoreQueryBuilder scoreMode(String scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    public CustomFiltersScoreQueryBuilder lang(String lang) {
        this.lang = lang;
        return this;
    }

    public CustomFiltersScoreQueryBuilder params(Map<String, Object> params2) {
        if (this.params == null) {
            this.params = params2;
        } else {
            this.params.putAll(params2);
        }
        return this;
    }

    public CustomFiltersScoreQueryBuilder param(String key2, Object value2) {
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        this.params.put(key2, value2);
        return this;
    }

    public CustomFiltersScoreQueryBuilder maxBoost(float maxBoost) {
        this.maxBoost = Float.valueOf(maxBoost);
        return this;
    }

    @Override
    public CustomFiltersScoreQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.startObject("custom_filters_score");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params2);
        builder.startArray("filters");
        for (int i2 = 0; i2 < this.filters.size(); ++i2) {
            builder.startObject();
            builder.field("filter");
            this.filters.get(i2).toXContent(builder, params2);
            String script = this.scripts.get(i2);
            if (script != null) {
                builder.field("script", script);
            } else {
                builder.field("boost", this.boosts.get(i2));
            }
            builder.endObject();
        }
        builder.endArray();
        if (this.scoreMode != null) {
            builder.field("score_mode", this.scoreMode);
        }
        if (this.maxBoost != null) {
            builder.field("max_boost", this.maxBoost);
        }
        if (this.lang != null) {
            builder.field("lang", this.lang);
        }
        if (this.params != null) {
            builder.field("params", this.params);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

