/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;

public class UidFieldMapper
extends AbstractFieldMapper<Uid>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_uid".intern();
    public static final Term TERM_FACTORY = new Term(NAME, "");
    public static final String CONTENT_TYPE = "_uid";
    private ThreadLocal<UidField> fieldCache = new ThreadLocal<UidField>(){

        @Override
        protected UidField initialValue() {
            return new UidField(UidFieldMapper.this.names().indexName(), "", 0L);
        }
    };

    public UidFieldMapper() {
        this(Defaults.NAME);
    }

    protected UidFieldMapper(String name2) {
        this(name2, name2);
    }

    protected UidFieldMapper(String name2, String indexName) {
        super(new FieldMapper.Names(name2, indexName, indexName, name2), Defaults.INDEX, Field.Store.YES, Defaults.TERM_VECTOR, 1.0f, true, Defaults.INDEX_OPTIONS, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        if (context.sourceToParse().id() != null) {
            context.id(context.sourceToParse().id());
            super.parse(context);
        }
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        if (context.id() == null && !context.sourceToParse().flyweight()) {
            throw new MapperParsingException("No id found while parsing the content source");
        }
        if (context.sourceToParse().id() == null) {
            super.parse(context);
            if (context.docs().size() > 1) {
                UidField uidField = (UidField)context.rootDoc().getFieldable(NAME);
                assert (uidField != null);
                for (int i2 = 1; i2 < context.docs().size(); ++i2) {
                    context.docs().get(i2).add(new Field(NAME, uidField.uid(), Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
            }
        }
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        context.uid(Uid.createUid(context.stringBuilder(), context.type(), context.id()));
        UidField field2 = this.fieldCache.get();
        field2.setUid(context.uid());
        return field2;
    }

    @Override
    public Uid value(Fieldable field2) {
        return Uid.createUid(field2.stringValue());
    }

    @Override
    public Uid valueFromString(String value2) {
        return Uid.createUid(value2);
    }

    @Override
    public String valueAsString(Fieldable field2) {
        return field2.stringValue();
    }

    @Override
    public String indexedValue(String value2) {
        return value2;
    }

    public Term term(String type2, String id2) {
        return this.term(Uid.createUid(type2, id2));
    }

    public Term term(String uid2) {
        return this.names().createIndexNameTerm(uid2);
    }

    @Override
    public void close() {
        this.fieldCache.remove();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name2, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            return MapperBuilders.uid();
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, UidFieldMapper> {
        protected String indexName;

        public Builder() {
            super(Defaults.NAME);
            this.indexName = this.name;
        }

        @Override
        public UidFieldMapper build(Mapper.BuilderContext context) {
            return new UidFieldMapper(this.name, this.indexName);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = NAME;
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final boolean OMIT_NORMS = true;
        public static final FieldInfo.IndexOptions INDEX_OPTIONS = FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
    }
}

