/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class TimestampFieldMapper
extends DateFieldMapper
implements InternalMapper,
RootMapper {
    public static final String NAME = "_timestamp";
    public static final String CONTENT_TYPE = "_timestamp";
    public static final String DEFAULT_DATE_TIME_FORMAT = "dateOptionalTime";
    private boolean enabled;
    private final String path;

    public TimestampFieldMapper() {
        this(Defaults.STORE, Defaults.INDEX, false, Defaults.PATH, Defaults.DATE_TIME_FORMATTER, true, Defaults.IGNORE_MALFORMED);
    }

    protected TimestampFieldMapper(Field.Store store, Field.Index index2, boolean enabled, String path2, FormatDateTimeFormatter dateTimeFormatter, boolean parseUpperInclusive, Explicit<Boolean> ignoreMalformed) {
        super(new FieldMapper.Names("_timestamp", "_timestamp", "_timestamp", "_timestamp"), dateTimeFormatter, 4, Defaults.FUZZY_FACTOR, index2, store, 1.0f, true, Defaults.INDEX_OPTIONS, Defaults.NULL_VALUE, TimeUnit.MILLISECONDS, parseUpperInclusive, ignoreMalformed);
        this.enabled = enabled;
        this.path = path2;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public String path() {
        return this.path;
    }

    public FormatDateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    @Override
    public Object valueForSearch(Fieldable field2) {
        return this.value(field2);
    }

    @Override
    public String valueAsString(Fieldable field2) {
        Long value2 = this.value(field2);
        if (value2 == null) {
            return null;
        }
        return value2.toString();
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected Fieldable innerParseCreateField(ParseContext context) throws IOException {
        if (this.enabled) {
            long timestamp = context.sourceToParse().timestamp();
            if (!this.indexed() && !this.stored()) {
                context.ignoredValue(this.names.indexName(), String.valueOf(timestamp));
                return null;
            }
            return new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, timestamp);
        }
        return null;
    }

    @Override
    protected String contentType() {
        return "_timestamp";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (this.index == Defaults.INDEX && this.store == Defaults.STORE && !this.enabled && this.path == Defaults.PATH && this.dateTimeFormatter.format().equals(Defaults.DATE_TIME_FORMATTER.format())) {
            return builder;
        }
        builder.startObject("_timestamp");
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.path != Defaults.PATH) {
            builder.field("path", this.path);
        }
        if (!this.dateTimeFormatter.format().equals(Defaults.DATE_TIME_FORMATTER.format())) {
            builder.field("format", this.dateTimeFormatter.format());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name2, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.timestamp();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("path")) {
                    builder.path(fieldNode.toString());
                    continue;
                }
                if (!fieldName.equals("format")) continue;
                builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(builder.name(), fieldNode.toString()));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, TimestampFieldMapper> {
        private boolean enabled = false;
        private String path = Defaults.PATH;
        private FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;

        public Builder() {
            super("_timestamp");
            this.store = Defaults.STORE;
            this.index = Defaults.INDEX;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return (Builder)this.builder;
        }

        public Builder path(String path2) {
            this.path = path2;
            return (Builder)this.builder;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return (Builder)this.builder;
        }

        @Override
        public TimestampFieldMapper build(Mapper.BuilderContext context) {
            boolean parseUpperInclusive = true;
            if (context.indexSettings() != null) {
                parseUpperInclusive = context.indexSettings().getAsBoolean("index.mapping.date.parse_upper_inclusive", true);
            }
            return new TimestampFieldMapper(this.store, this.index, this.enabled, this.path, this.dateTimeFormatter, parseUpperInclusive, this.ignoreMalformed(context));
        }
    }

    public static class Defaults
    extends DateFieldMapper.Defaults {
        public static final String NAME = "_timestamp";
        public static final Field.Store STORE = Field.Store.NO;
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final boolean ENABLED = false;
        public static final String PATH = null;
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime");
    }
}

