/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericFloatAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.FloatFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class BoostFieldMapper
extends NumberFieldMapper<Float>
implements InternalMapper,
RootMapper {
    public static final String CONTENT_TYPE = "_boost";
    public static final String NAME = "_boost";
    private final Float nullValue;

    public BoostFieldMapper() {
        this("_boost", "_boost");
    }

    protected BoostFieldMapper(String name2, String indexName) {
        this(name2, indexName, 4, Defaults.INDEX, Defaults.STORE, 1.0f, true, Defaults.INDEX_OPTIONS, Defaults.NULL_VALUE);
    }

    protected BoostFieldMapper(String name2, String indexName, int precisionStep, Field.Index index2, Field.Store store, float boost, boolean omitNorms, FieldInfo.IndexOptions indexOptions, Float nullValue) {
        super(new FieldMapper.Names(name2, indexName, indexName, name2), precisionStep, null, index2, store, boost, omitNorms, indexOptions, Defaults.IGNORE_MALFORMED, new NamedAnalyzer("_float/" + precisionStep, new NumericFloatAnalyzer(precisionStep)), new NamedAnalyzer("_float/max", new NumericFloatAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Float value(Fieldable field2) {
        byte[] value2 = field2.getBinaryValue();
        if (value2 == null) {
            return null;
        }
        return Float.valueOf(Numbers.bytesToFloat(value2));
    }

    @Override
    public Float valueFromString(String value2) {
        return Float.valueOf(Float.parseFloat(value2));
    }

    @Override
    public String indexedValue(String value2) {
        return NumericUtils.floatToPrefixCoded(Float.parseFloat(value2));
    }

    @Override
    public Query fuzzyQuery(String value2, String minSim, int prefixLength, int maxExpansions) {
        float iValue = Float.parseFloat(value2);
        float iSim = Float.parseFloat(minSim);
        return NumericRangeQuery.newFloatRange(this.names.indexName(), this.precisionStep, Float.valueOf(iValue - iSim), Float.valueOf(iValue + iSim), true, true);
    }

    @Override
    public Query fuzzyQuery(String value2, double minSim, int prefixLength, int maxExpansions) {
        float iValue = Float.parseFloat(value2);
        float iSim = (float)(minSim * this.dFuzzyFactor);
        return NumericRangeQuery.newFloatRange(this.names.indexName(), this.precisionStep, Float.valueOf(iValue - iSim), Float.valueOf(iValue + iSim), true, true);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newFloatRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm)), upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newFloatRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm)), upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newFloatRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm)), upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return NumericRangeFilter.newFloatRange(this.names.indexName(), this.precisionStep, this.nullValue, this.nullValue, true, true);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        float value2 = this.parseFloatValue(context);
        if (!Float.isNaN(value2)) {
            context.doc().setBoost(value2);
        }
        super.parse(context);
    }

    @Override
    protected Fieldable innerParseCreateField(ParseContext context) throws IOException {
        float value2 = this.parseFloatValue(context);
        if (Float.isNaN(value2)) {
            return null;
        }
        context.doc().setBoost(value2);
        return new FloatFieldMapper.CustomFloatNumericField((NumberFieldMapper)this, value2);
    }

    private float parseFloatValue(ParseContext context) throws IOException {
        float value2;
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return Float.NaN;
            }
            value2 = this.nullValue.floatValue();
        } else {
            value2 = context.parser().floatValue();
        }
        return value2;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.FLOAT;
    }

    @Override
    protected String contentType() {
        return "_boost";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        if (this.name().equals("_boost") && this.nullValue == null) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (!this.name().equals("_boost")) {
            builder.field("name", this.name());
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String fieldName, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            String name2 = node.get("name") == null ? "_boost" : node.get("name").toString();
            Builder builder = MapperBuilders.boost(name2);
            TypeParsers.parseNumberField(builder, name2, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeFloatValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, BoostFieldMapper> {
        protected Float nullValue = Defaults.NULL_VALUE;

        public Builder(String name2) {
            super(name2);
            this.builder = this;
            this.index = Defaults.INDEX;
            this.store = Defaults.STORE;
        }

        public Builder nullValue(float nullValue) {
            this.nullValue = Float.valueOf(nullValue);
            return this;
        }

        @Override
        public BoostFieldMapper build(Mapper.BuilderContext context) {
            return new BoostFieldMapper(this.name, this.buildIndexName(context), this.precisionStep, this.index, this.store, this.boost, this.omitNorms, this.indexOptions, this.nullValue);
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final String NAME = "_boost";
        public static final Float NULL_VALUE = null;
        public static final Field.Index INDEX = Field.Index.NO;
        public static final Field.Store STORE = Field.Store.NO;
    }
}

