/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NamedCustomAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;

public class StringFieldMapper
extends AbstractFieldMapper<String>
implements AllFieldMapper.IncludeInAll {
    public static final String CONTENT_TYPE = "string";
    private String nullValue;
    private Boolean includeInAll;
    private int positionOffsetGap;
    private NamedAnalyzer searchQuotedAnalyzer;
    private int ignoreAbove;

    protected StringFieldMapper(FieldMapper.Names names2, Field.Index index2, Field.Store store, Field.TermVector termVector, float boost, boolean omitNorms, FieldInfo.IndexOptions indexOptions, String nullValue, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer) {
        this(names2, index2, store, termVector, boost, omitNorms, indexOptions, nullValue, indexAnalyzer, searchAnalyzer, searchAnalyzer, 0, -1);
    }

    protected StringFieldMapper(FieldMapper.Names names2, Field.Index index2, Field.Store store, Field.TermVector termVector, float boost, boolean omitNorms, FieldInfo.IndexOptions indexOptions, String nullValue, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuotedAnalyzer, int positionOffsetGap, int ignoreAbove) {
        super(names2, index2, store, termVector, boost, omitNorms, indexOptions, indexAnalyzer, searchAnalyzer);
        this.nullValue = nullValue;
        this.positionOffsetGap = positionOffsetGap;
        this.searchQuotedAnalyzer = searchQuotedAnalyzer != null ? searchQuotedAnalyzer : this.searchAnalyzer;
        this.ignoreAbove = ignoreAbove;
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.includeInAll == null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public String value(Fieldable field2) {
        return field2.stringValue();
    }

    @Override
    public String valueFromString(String value2) {
        return value2;
    }

    @Override
    public String valueAsString(Fieldable field2) {
        return this.value(field2);
    }

    @Override
    public String indexedValue(String value2) {
        return value2;
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    public int getPositionOffsetGap() {
        return this.positionOffsetGap;
    }

    @Override
    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuotedAnalyzer;
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return this.fieldFilter(this.nullValue, null);
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        String value2 = this.nullValue;
        float boost = this.boost;
        if (context.externalValueSet()) {
            value2 = (String)context.externalValue();
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                value2 = this.nullValue;
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        value2 = parser.textOrNull();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
            } else {
                value2 = parser.textOrNull();
            }
        }
        if (value2 == null) {
            return null;
        }
        if (this.ignoreAbove > 0 && value2.length() > this.ignoreAbove) {
            return null;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.names.fullName(), value2, boost);
        }
        if (!this.indexed() && !this.stored()) {
            context.ignoredValue(this.names.indexName(), value2);
            return null;
        }
        Field field2 = new Field(this.names.indexName(), false, value2, this.store, this.index, this.termVector);
        field2.setBoost(boost);
        return field2;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.includeInAll = ((StringFieldMapper)mergeWith).includeInAll;
            this.nullValue = ((StringFieldMapper)mergeWith).nullValue;
            this.ignoreAbove = ((StringFieldMapper)mergeWith).ignoreAbove;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (this.indexOptions != Defaults.INDEX_OPTIONS) {
            builder.field("index_options", StringFieldMapper.indexOptionToString(this.indexOptions));
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
        if (this.positionOffsetGap != 0) {
            builder.field("position_offset_gap", this.positionOffsetGap);
        }
        if (this.searchQuotedAnalyzer != null && this.searchAnalyzer != this.searchQuotedAnalyzer) {
            builder.field("search_quote_analyzer", this.searchQuotedAnalyzer.name());
        }
        if (this.ignoreAbove != -1) {
            builder.field("ignore_above", this.ignoreAbove);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name2, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.stringField(name2);
            TypeParsers.parseField(builder, name2, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(propNode.toString());
                    continue;
                }
                if (propName.equals("search_quote_analyzer")) {
                    NamedAnalyzer analyzer = parserContext.analysisService().analyzer(propNode.toString());
                    if (analyzer == null) {
                        throw new MapperParsingException("Analyzer [" + propNode.toString() + "] not found for field [" + name2 + "]");
                    }
                    builder.searchQuotedAnalyzer(analyzer);
                    continue;
                }
                if (propName.equals("position_offset_gap")) {
                    builder.positionOffsetGap(XContentMapValues.nodeIntegerValue(propNode, -1));
                    if (builder.indexAnalyzer == null) {
                        builder.indexAnalyzer = parserContext.analysisService().defaultIndexAnalyzer();
                    }
                    if (builder.searchAnalyzer == null) {
                        builder.searchAnalyzer = parserContext.analysisService().defaultSearchAnalyzer();
                    }
                    if (builder.searchQuotedAnalyzer != null) continue;
                    builder.searchQuotedAnalyzer = parserContext.analysisService().defaultSearchQuoteAnalyzer();
                    continue;
                }
                if (!propName.equals("ignore_above")) continue;
                builder.ignoreAbove(XContentMapValues.nodeIntegerValue(propNode, -1));
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.OpenBuilder<Builder, StringFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;
        protected int positionOffsetGap = 0;
        protected NamedAnalyzer searchQuotedAnalyzer;
        protected int ignoreAbove = -1;

        public Builder(String name2) {
            super(name2);
            this.builder = this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public Builder includeInAll(Boolean includeInAll) {
            this.includeInAll = includeInAll;
            return this;
        }

        @Override
        public Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            super.searchAnalyzer(searchAnalyzer);
            if (this.searchQuotedAnalyzer == null) {
                this.searchQuotedAnalyzer = searchAnalyzer;
            }
            return this;
        }

        public Builder positionOffsetGap(int positionOffsetGap) {
            this.positionOffsetGap = positionOffsetGap;
            return this;
        }

        public Builder searchQuotedAnalyzer(NamedAnalyzer analyzer) {
            this.searchQuotedAnalyzer = analyzer;
            return (Builder)this.builder;
        }

        public Builder ignoreAbove(int ignoreAbove) {
            this.ignoreAbove = ignoreAbove;
            return this;
        }

        @Override
        public StringFieldMapper build(Mapper.BuilderContext context) {
            if (this.positionOffsetGap > 0) {
                this.indexAnalyzer = new NamedCustomAnalyzer(this.indexAnalyzer, this.positionOffsetGap);
                this.searchAnalyzer = new NamedCustomAnalyzer(this.searchAnalyzer, this.positionOffsetGap);
                this.searchQuotedAnalyzer = new NamedCustomAnalyzer(this.searchQuotedAnalyzer, this.positionOffsetGap);
            }
            if (this.index == Field.Index.NOT_ANALYZED) {
                if (!this.omitNormsSet) {
                    this.omitNorms = true;
                }
                if (!this.indexOptionsSet) {
                    this.indexOptions = FieldInfo.IndexOptions.DOCS_ONLY;
                }
            }
            StringFieldMapper fieldMapper = new StringFieldMapper(this.buildNames(context), this.index, this.store, this.termVector, this.boost, this.omitNorms, this.indexOptions, this.nullValue, this.indexAnalyzer, this.searchAnalyzer, this.searchQuotedAnalyzer, this.positionOffsetGap, this.ignoreAbove);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NULL_VALUE = null;
        public static final int POSITION_OFFSET_GAP = 0;
        public static final int IGNORE_ABOVE = -1;
    }
}

