/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericDateAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class DateFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "date";
    protected final FormatDateTimeFormatter dateTimeFormatter;
    private final boolean parseUpperInclusive;
    private final DateMathParser dateMathParser;
    private String nullValue;
    protected final TimeUnit timeUnit;

    protected DateFieldMapper(FieldMapper.Names names2, FormatDateTimeFormatter dateTimeFormatter, int precisionStep, String fuzzyFactor, Field.Index index2, Field.Store store, float boost, boolean omitNorms, FieldInfo.IndexOptions indexOptions, String nullValue, TimeUnit timeUnit, boolean parseUpperInclusive, Explicit<Boolean> ignoreMalformed) {
        super(names2, precisionStep, fuzzyFactor, index2, store, boost, omitNorms, indexOptions, ignoreMalformed, new NamedAnalyzer("_date/" + precisionStep, new NumericDateAnalyzer(precisionStep, dateTimeFormatter.parser())), new NamedAnalyzer("_date/max", new NumericDateAnalyzer(Integer.MAX_VALUE, dateTimeFormatter.parser())));
        this.dateTimeFormatter = dateTimeFormatter;
        this.nullValue = nullValue;
        this.timeUnit = timeUnit;
        this.parseUpperInclusive = parseUpperInclusive;
        this.dateMathParser = new DateMathParser(dateTimeFormatter, timeUnit);
    }

    @Override
    protected double parseFuzzyFactor(String fuzzyFactor) {
        if (fuzzyFactor == null) {
            return 1.0;
        }
        try {
            return TimeValue.parseTimeValue(fuzzyFactor, null).millis();
        }
        catch (Exception e) {
            return Double.parseDouble(fuzzyFactor);
        }
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Fieldable field2) {
        byte[] value2 = field2.getBinaryValue();
        if (value2 == null) {
            return null;
        }
        return Numbers.bytesToLong(value2);
    }

    @Override
    public Long valueFromString(String value2) {
        return this.parseStringValue(value2);
    }

    @Override
    public Object valueForSearch(Fieldable field2) {
        return this.valueAsString(field2);
    }

    @Override
    public String valueAsString(Fieldable field2) {
        Long value2 = this.value(field2);
        if (value2 == null) {
            return null;
        }
        return this.dateTimeFormatter.printer().print(value2);
    }

    @Override
    public String indexedValue(String value2) {
        return NumericUtils.longToPrefixCoded(this.dateTimeFormatter.parser().parseMillis(value2));
    }

    @Override
    public Query fuzzyQuery(String value2, String minSim, int prefixLength, int maxExpansions) {
        long iSim;
        long iValue = this.dateMathParser.parse(value2, System.currentTimeMillis());
        try {
            iSim = TimeValue.parseTimeValue(minSim, null).millis();
        }
        catch (Exception e) {
            iSim = (long)Double.parseDouble(minSim);
        }
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, iValue - iSim, iValue + iSim, true, true);
    }

    @Override
    public Query fuzzyQuery(String value2, double minSim, int prefixLength, int maxExpansions) {
        long iValue = this.dateMathParser.parse(value2, System.currentTimeMillis());
        long iSim = (long)(minSim * this.dFuzzyFactor);
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, iValue - iSim, iValue + iSim, true, true);
    }

    @Override
    public Query fieldQuery(String value2, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        long lValue = this.dateMathParser.parse(value2, now);
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, lValue, lValue, true, true);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        return NumericRangeQuery.newLongRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Long.valueOf(this.dateMathParser.parse(lowerTerm, now)), upperTerm == null ? null : Long.valueOf(includeUpper && this.parseUpperInclusive ? this.dateMathParser.parseUpperInclusive(upperTerm, now) : this.dateMathParser.parse(upperTerm, now)), includeLower, includeUpper);
    }

    @Override
    public Filter fieldFilter(String value2, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        long lValue = this.dateMathParser.parse(value2, now);
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, lValue, lValue, true, true);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Long.valueOf(this.dateMathParser.parse(lowerTerm, now)), upperTerm == null ? null : Long.valueOf(includeUpper && this.parseUpperInclusive ? this.dateMathParser.parseUpperInclusive(upperTerm, now) : this.dateMathParser.parse(upperTerm, now)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        return NumericRangeFieldDataFilter.newLongRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Long.valueOf(this.dateMathParser.parse(lowerTerm, now)), upperTerm == null ? null : Long.valueOf(includeUpper && this.parseUpperInclusive ? this.dateMathParser.parseUpperInclusive(upperTerm, now) : this.dateMathParser.parse(upperTerm, now)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        long value2 = this.parseStringValue(this.nullValue);
        return NumericRangeFilter.newLongRange(this.names.indexName(), this.precisionStep, value2, value2, true, true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected Fieldable innerParseCreateField(ParseContext context) throws IOException {
        LongFieldMapper.CustomLongNumericField field2;
        String dateAsString = null;
        Long value2 = null;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue instanceof Number) {
                value2 = ((Number)externalValue).longValue();
            } else {
                dateAsString = (String)externalValue;
                if (dateAsString == null) {
                    dateAsString = this.nullValue;
                }
            }
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                dateAsString = this.nullValue;
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                value2 = parser.longValue();
            } else if (token == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (token == XContentParser.Token.VALUE_NULL) {
                            dateAsString = this.nullValue;
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            value2 = parser.longValue();
                            continue;
                        }
                        dateAsString = parser.text();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
            } else {
                dateAsString = parser.text();
            }
        }
        if (value2 != null) {
            field2 = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, this.timeUnit.toMillis(value2));
            field2.setBoost(boost);
            return field2;
        }
        if (dateAsString == null) {
            return null;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.names.fullName(), dateAsString, boost);
        }
        value2 = this.parseStringValue(dateAsString);
        field2 = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, value2);
        field2.setBoost(boost);
        return field2;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.LONG;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((DateFieldMapper)mergeWith).nullValue;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (this.indexOptions != Defaults.INDEX_OPTIONS) {
            builder.field("index_options", DateFieldMapper.indexOptionToString(this.indexOptions));
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.fuzzyFactor != Defaults.FUZZY_FACTOR) {
            builder.field("fuzzy_factor", this.fuzzyFactor);
        }
        builder.field("format", this.dateTimeFormatter.format());
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
        if (this.timeUnit != Defaults.TIME_UNIT) {
            builder.field("numeric_resolution", this.timeUnit.name().toLowerCase());
        }
    }

    private long parseStringValue(String value2) {
        try {
            return this.dateTimeFormatter.parser().parseMillis(value2);
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value2);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new MapperParsingException("failed to parse date field [" + value2 + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name2, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.dateField(name2);
            TypeParsers.parseNumberField(builder, name2, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(propNode.toString());
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propName, propNode));
                    continue;
                }
                if (!propName.equals("numeric_resolution")) continue;
                builder.timeUnit(TimeUnit.valueOf(propNode.toString().toUpperCase()));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, DateFieldMapper> {
        protected TimeUnit timeUnit = Defaults.TIME_UNIT;
        protected String nullValue = Defaults.NULL_VALUE;
        protected FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;

        public Builder(String name2) {
            super(name2);
            this.builder = this;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            boolean parseUpperInclusive = true;
            if (context.indexSettings() != null) {
                parseUpperInclusive = context.indexSettings().getAsBoolean("index.mapping.date.parse_upper_inclusive", true);
            }
            DateFieldMapper fieldMapper = new DateFieldMapper(this.buildNames(context), this.dateTimeFormatter, this.precisionStep, this.fuzzyFactor, this.index, this.store, this.boost, this.omitNorms, this.indexOptions, this.nullValue, this.timeUnit, parseUpperInclusive, this.ignoreMalformed(context));
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime");
        public static final String NULL_VALUE = null;
        public static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
        public static final boolean PARSE_UPPER_INCLUSIVE = true;
    }
}

