/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.strings;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.strings.MultiValueStringFieldData;
import org.elasticsearch.index.field.data.strings.SingleValueStringFieldData;

public class StringOrdValFieldDataComparator
extends FieldComparator {
    private final FieldDataCache fieldDataCache;
    private final int[] ords;
    private final String[] values;
    private final int[] readerGen;
    private int currentReaderGen = -1;
    private String[] lookup;
    private int[] order;
    private final String field;
    private int bottomSlot = -1;
    private int bottomOrd;
    private boolean bottomSameReader;
    private String bottomValue;

    public StringOrdValFieldDataComparator(int numHits, String field2, int sortPos, boolean reversed, FieldDataCache fieldDataCache) {
        this.fieldDataCache = fieldDataCache;
        this.ords = new int[numHits];
        this.values = new String[numHits];
        this.readerGen = new int[numHits];
        this.field = field2;
    }

    @Override
    public int compare(int slot1, int slot2) {
        if (this.readerGen[slot1] == this.readerGen[slot2]) {
            return this.ords[slot1] - this.ords[slot2];
        }
        String val1 = this.values[slot1];
        String val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return val1.compareTo(val2);
    }

    @Override
    public int compareBottom(int doc) {
        assert (this.bottomSlot != -1);
        if (this.bottomSameReader) {
            return this.bottomOrd - this.order[doc];
        }
        int order2 = this.order[doc];
        int cmp2 = this.bottomOrd - order2;
        if (cmp2 != 0) {
            return cmp2;
        }
        String val2 = this.lookup[order2];
        if (this.bottomValue == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return this.bottomValue.compareTo(val2);
    }

    @Override
    public void copy(int slot, int doc) {
        int ord2;
        this.ords[slot] = ord2 = this.order[doc];
        assert (ord2 >= 0);
        this.values[slot] = this.lookup[ord2];
        this.readerGen[slot] = this.currentReaderGen;
    }

    @Override
    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        FieldData cleanFieldData = this.fieldDataCache.cache(FieldDataType.DefaultTypes.STRING, reader, this.field);
        if (cleanFieldData instanceof MultiValueStringFieldData) {
            throw new IOException("Can't sort on string types with more than one value per doc, or more than one token per field");
        }
        SingleValueStringFieldData fieldData = (SingleValueStringFieldData)cleanFieldData;
        ++this.currentReaderGen;
        this.order = fieldData.ordinals();
        this.lookup = fieldData.values();
        assert (this.lookup.length > 0);
        if (this.bottomSlot != -1) {
            this.setBottom(this.bottomSlot);
        }
    }

    @Override
    public void setBottom(int bottom) {
        this.bottomSlot = bottom;
        this.bottomValue = this.values[this.bottomSlot];
        if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
            this.bottomOrd = this.ords[this.bottomSlot];
            this.bottomSameReader = true;
        } else if (this.bottomValue == null) {
            this.ords[this.bottomSlot] = 0;
            this.bottomOrd = 0;
            this.bottomSameReader = true;
            this.readerGen[this.bottomSlot] = this.currentReaderGen;
        } else {
            int index2 = StringOrdValFieldDataComparator.binarySearch(this.lookup, this.bottomValue);
            if (index2 < 0) {
                this.bottomOrd = -index2 - 2;
                this.bottomSameReader = false;
            } else {
                this.bottomOrd = index2;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
                this.ords[this.bottomSlot] = this.bottomOrd;
            }
        }
    }

    public Comparable value(int slot) {
        return this.values[slot];
    }

    public String[] getValues() {
        return this.values;
    }

    public int getBottomSlot() {
        return this.bottomSlot;
    }

    public String getField() {
        return this.field;
    }
}

