/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.strings;

import org.elasticsearch.common.RamUsage;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.concurrent.ThreadLocals;
import org.elasticsearch.index.field.data.FieldData;
import org.elasticsearch.index.field.data.strings.StringFieldData;

public class MultiValueStringFieldData
extends StringFieldData {
    private static final int VALUE_CACHE_SIZE = 100;
    private static ThreadLocal<ThreadLocals.CleanableValue<String[][]>> valuesCache = new ThreadLocal<ThreadLocals.CleanableValue<String[][]>>(){

        @Override
        protected ThreadLocals.CleanableValue<String[][]> initialValue() {
            String[][] value2 = new String[100][];
            for (int i2 = 0; i2 < value2.length; ++i2) {
                value2[i2] = new String[i2];
            }
            return new ThreadLocals.CleanableValue<String[][]>(value2);
        }
    };
    private final int[][] ordinals;

    public MultiValueStringFieldData(String fieldName, int[][] ordinals, String[] values2) {
        super(fieldName, values2);
        this.ordinals = ordinals;
    }

    @Override
    protected long computeSizeInBytes() {
        long size2 = super.computeSizeInBytes();
        size2 += (long)RamUsage.NUM_BYTES_ARRAY_HEADER;
        for (int[] ordinal : this.ordinals) {
            size2 += (long)(4 * ordinal.length + RamUsage.NUM_BYTES_ARRAY_HEADER);
        }
        return size2;
    }

    @Override
    public boolean multiValued() {
        return true;
    }

    @Override
    public boolean hasValue(int docId) {
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void forEachValueInDoc(int docId, FieldData.StringValueInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onMissing(docId);
                break;
            }
            proc2.onValue(docId, this.values[loc]);
        }
    }

    @Override
    public void forEachOrdinalInDoc(int docId, FieldData.OrdinalInDocProc proc2) {
        for (int i2 = 0; i2 < this.ordinals.length; ++i2) {
            int loc = this.ordinals[i2][docId];
            if (loc == 0) {
                if (i2 != 0) break;
                proc2.onOrdinal(docId, 0);
                break;
            }
            proc2.onOrdinal(docId, loc);
        }
    }

    @Override
    public String value(int docId) {
        for (int[] ordinal : this.ordinals) {
            int loc = ordinal[docId];
            if (loc == 0) continue;
            return this.values[loc];
        }
        return null;
    }

    @Override
    public String[] values(int docId) {
        int length2 = 0;
        for (int[] ordinal : this.ordinals) {
            if (ordinal[docId] == 0) break;
            ++length2;
        }
        if (length2 == 0) {
            return Strings.EMPTY_ARRAY;
        }
        String[] strings = length2 < 100 ? valuesCache.get().get()[length2] : new String[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            strings[i2] = this.values[this.ordinals[i2][docId]];
        }
        return strings;
    }
}

